/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.network.EnergyNetworkConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.PartNetworkConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.network.Network;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public class NetworkHelpers {
    public static INetworkCarrier getNetworkCarrier(IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return (INetworkCarrier)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side, NetworkCarrierConfig.CAPABILITY);
    }

    public static INetworkElementProvider getNetworkElementProvider(IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return (INetworkElementProvider)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side, NetworkElementProviderConfig.CAPABILITY);
    }

    public static INetwork getNetwork(IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        INetworkCarrier networkCarrier = NetworkHelpers.getNetworkCarrier(world, pos, side);
        if (networkCarrier != null) {
            return networkCarrier.getNetwork();
        }
        return null;
    }

    public static IPartNetwork getPartNetwork(@Nullable INetwork network) {
        return network != null && network.hasCapability(PartNetworkConfig.CAPABILITY) ? network.getCapability(PartNetworkConfig.CAPABILITY) : null;
    }

    public static IEnergyNetwork getEnergyNetwork(@Nullable INetwork network) {
        return network != null && network.hasCapability(EnergyNetworkConfig.CAPABILITY) ? network.getCapability(EnergyNetworkConfig.CAPABILITY) : null;
    }

    @Nullable
    public static INetwork initNetwork(World world, BlockPos pos, @Nullable EnumFacing side) {
        IPathElement pathElement = (IPathElement)TileHelpers.getCapability((World)world, (BlockPos)pos, (EnumFacing)side, PathElementConfig.CAPABILITY);
        if (pathElement != null) {
            Network network = Network.initiateNetworkSetup(SidedPathElement.of(pathElement, side));
            network.initialize();
            return network;
        }
        return null;
    }

    public static void onElementProviderBlockNeighborChange(World world, BlockPos pos, Block neighborBlock, @Nullable EnumFacing side) {
        if (!world.field_72995_K) {
            INetwork network = NetworkHelpers.getNetwork((IBlockAccess)world, pos, side);
            INetworkElementProvider networkElementProvider = NetworkHelpers.getNetworkElementProvider((IBlockAccess)world, pos, side);
            for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                networkElement.onNeighborBlockChange(network, (IBlockAccess)world, neighborBlock);
            }
        }
    }

    public static boolean shouldWork() {
        return !GeneralConfig.safeMode;
    }

    public static void invalidateNetworkElements(World world, BlockPos pos) {
        INetworkElementProvider networkElementProvider;
        INetwork network;
        INetworkCarrier networkCarrier = (INetworkCarrier)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, NetworkCarrierConfig.CAPABILITY);
        if (networkCarrier != null && (network = networkCarrier.getNetwork()) != null && (networkElementProvider = (INetworkElementProvider)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, NetworkElementProviderConfig.CAPABILITY)) != null) {
            for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                networkElement.invalidate(network);
            }
        }
    }

    public static void revalidateNetworkElements(World world, BlockPos pos) {
        INetworkElementProvider networkElementProvider;
        INetworkCarrier networkCarrier = (INetworkCarrier)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, NetworkCarrierConfig.CAPABILITY);
        IPathElement pathElement = (IPathElement)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, PathElementConfig.CAPABILITY);
        if (networkCarrier != null && pathElement != null && networkCarrier.getNetwork() == null && (networkElementProvider = (INetworkElementProvider)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, NetworkElementProviderConfig.CAPABILITY)) != null) {
            for (INetwork network : NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getNetworks()) {
                if (!network.containsSidedPathElement(SidedPathElement.of(pathElement, null))) continue;
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.revalidate(network);
                }
            }
        }
    }
}

