/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.expression;

import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.IExpression;
import org.cyclops.integrateddynamics.api.evaluate.expression.ILazyExpressionValueCache;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;

public class LazyExpression<V extends IValue>
extends VariableAdapter<V>
implements IExpression<V> {
    private final int id;
    private final IOperator op;
    private final IVariable[] input;
    private final ILazyExpressionValueCache valueCache;
    private boolean errored = false;

    public LazyExpression(int id, IOperator op, IVariable[] input, ILazyExpressionValueCache valueCache) {
        this.id = id;
        this.op = op;
        this.input = input;
        this.valueCache = valueCache;
        valueCache.removeValue(id);
    }

    @Override
    public IValue evaluate() throws EvaluationException {
        if (this.valueCache.hasValue(this.id)) {
            return this.valueCache.getValue(this.id);
        }
        IValue value = this.op.evaluate(this.input);
        for (IVariable inputVariable : this.input) {
            inputVariable.addDependent(this);
        }
        this.valueCache.setValue(this.id, value);
        return value;
    }

    @Override
    public boolean hasErrored() {
        return this.errored;
    }

    @Override
    public IValueType<V> getType() {
        return this.op.getConditionalOutputType(this.input);
    }

    @Override
    public V getValue() throws EvaluationException {
        IValue value;
        try {
            value = this.evaluate();
        }
        catch (EvaluationException e) {
            this.errored = true;
            throw new EvaluationException(e.getMessage());
        }
        try {
            return (V)value;
        }
        catch (ClassCastException e) {
            this.errored = true;
            throw new EvaluationException(String.format("The evaluation for operator %s returned %s instead of the expected %s.", this.op, value.getType(), this.op.getOutputType()));
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.valueCache.removeValue(this.id);
    }

    public IOperator getOperator() {
        return this.op;
    }

    public IVariable[] getInput() {
        return this.input;
    }
}

