/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.part;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.particle.ParticleBlur;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.part.PartOverlayRendererBase;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;

@SideOnly(value=Side.CLIENT)
public class ConnectorOmniPartOverlayRenderer
extends PartOverlayRendererBase {
    private static final TIntIntMap CACHED_GROUP_COLORS = new TIntIntHashMap();
    private final Random rand = new Random();

    protected static int getGroupColor(int group) {
        if (!CACHED_GROUP_COLORS.containsKey(group)) {
            Random rand = new Random(group);
            int color = rand.nextInt(0x800000) | 0xFF000000;
            CACHED_GROUP_COLORS.put(group, color);
            return color;
        }
        return CACHED_GROUP_COLORS.get(group);
    }

    @Override
    public void renderPartOverlay(IPartContainer partContainer, double x, double y, double z, float partialTick, int destroyStage, EnumFacing direction, IPartType partType, TileEntityRendererDispatcher rendererDispatcher) {
        PartTypeConnectorOmniDirectional.State partState;
        IPartState partStateUnsafe;
        BlockPos pos = partContainer.getPosition().getBlockPos();
        if (!this.shouldRender(pos)) {
            return;
        }
        if (this.rand.nextInt(20) == 0 && !Minecraft.func_71410_x().func_147113_T() && (partStateUnsafe = partContainer.getPartState(direction)) instanceof PartTypeConnectorOmniDirectional.State && (partState = (PartTypeConnectorOmniDirectional.State)partStateUnsafe).hasConnectorId()) {
            double tx = (float)pos.func_177958_n() + 0.5f + (float)direction.func_82601_c() * 1.15f - 0.03f + this.rand.nextFloat() * 0.04f + (direction.func_176740_k() != EnumFacing.Axis.X ? 0.25f - this.rand.nextFloat() * 0.5f : 0.0f);
            double ty = (float)pos.func_177956_o() + 0.5f + (float)direction.func_96559_d() * 1.15f - 0.03f + this.rand.nextFloat() * 0.04f + (direction.func_176740_k() != EnumFacing.Axis.Y ? 0.25f - this.rand.nextFloat() * 0.5f : 0.0f);
            double tz = (float)pos.func_177952_p() + 0.5f + (float)direction.func_82599_e() * 1.15f - 0.03f + this.rand.nextFloat() * 0.04f + (direction.func_176740_k() != EnumFacing.Axis.Z ? 0.25f - this.rand.nextFloat() * 0.5f : 0.0f);
            float scale = 0.15f;
            Triple colors = Helpers.intToRGB((int)ConnectorOmniPartOverlayRenderer.getGroupColor(partState.getGroupId()));
            float red = ((Float)colors.getLeft()).floatValue() + this.rand.nextFloat() * 0.1f - 0.05f;
            float green = ((Float)colors.getMiddle()).floatValue() + this.rand.nextFloat() * 0.1f - 0.05f;
            float blue = ((Float)colors.getRight()).floatValue() + this.rand.nextFloat() * 0.1f - 0.05f;
            float ageMultiplier = 17.0f;
            ParticleBlur blur = new ParticleBlur((World)Minecraft.func_71410_x().field_71441_e, tx, ty, tz, scale, (double)(-((float)direction.func_82601_c() * 0.05f + this.rand.nextFloat() * 0.02f - 0.01f)), (double)(-((float)direction.func_96559_d() * 0.05f + this.rand.nextFloat() * 0.02f - 0.01f)), (double)(-((float)direction.func_82599_e() * 0.05f + this.rand.nextFloat() * 0.02f - 0.01f)), red, green, blue, ageMultiplier);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)blur);
        }
    }
}

