/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.RecipeSorter;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.integrateddynamics.block.BlockDelay;
import org.cyclops.integrateddynamics.block.BlockDelayConfig;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.block.BlockProxy;
import org.cyclops.integrateddynamics.block.BlockProxyConfig;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;
import org.cyclops.integrateddynamics.core.item.ItemPart;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.core.recipe.ItemBlockEnergyContainerCombinationRecipe;
import org.cyclops.integrateddynamics.item.ItemFacadeConfig;
import org.cyclops.integrateddynamics.item.ItemVariable;
import org.cyclops.integrateddynamics.item.ItemVariableConfig;
import org.cyclops.integrateddynamics.recipe.ItemFacadeRecipe;
import org.cyclops.integrateddynamics.recipe.ItemNbtClearRecipe;
import org.cyclops.integrateddynamics.recipe.ItemVariableCopyRecipe;

public class ExtendedRecipeHandler
extends RecipeHandler {
    public ExtendedRecipeHandler(ModBase mod, String ... fileNames) {
        super(mod, fileNames);
    }

    protected void registerRecipeSorters() {
        super.registerRecipeSorters();
        RecipeSorter.register((String)"integrateddynamicsfacadecombination", ItemFacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"integrateddynamicsvariablecopy", ItemVariableCopyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"integrateddynamicsitemclear", ItemNbtClearRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"integrateddynamicsenergybatterycombination", ItemBlockEnergyContainerCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
    }

    protected void registerCustomRecipes() {
        super.registerCustomRecipes();
        if (ConfigHandler.isEnabled(ItemFacadeConfig.class)) {
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "facade_0"), (IRecipe)new ItemFacadeRecipe());
        }
        if (ConfigHandler.isEnabled(ItemVariableConfig.class)) {
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "variable_copy"), (IRecipe)new ItemVariableCopyRecipe());
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "variable_clear"), (IRecipe)new ItemNbtClearRecipe((Item)ItemVariable.getInstance()));
        }
        CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "part_clear"), (IRecipe)new ItemNbtClearRecipe(ItemPart.class, PartTypes.REDSTONE_READER.getItem()));
        if (ConfigHandler.isEnabled(BlockProxyConfig.class)) {
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "proxy_clear"), (IRecipe)new ItemNbtClearRecipe(Item.func_150898_a((Block)BlockProxy.getInstance())));
        }
        if (ConfigHandler.isEnabled(BlockDelayConfig.class)) {
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "delay_clear"), (IRecipe)new ItemNbtClearRecipe(Item.func_150898_a((Block)BlockDelay.getInstance())));
        }
        if (ConfigHandler.isEnabled(BlockEnergyBatteryConfig.class)) {
            for (int i = 1; i < 9; ++i) {
                ItemBlockEnergyContainer tankItem = (ItemBlockEnergyContainer)Item.func_150898_a((Block)BlockEnergyBattery.getInstance());
                CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "combine_battery_" + i), (IRecipe)new ItemBlockEnergyContainerCombinationRecipe(i, tankItem, BlockEnergyBatteryConfig.maxCapacity));
            }
        }
    }
}

