/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.init;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.core.AEConfig;
import appeng.integration.Integrations;
import appeng.tile.networking.TileController;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.wct.WCT;
import p455w0rd.wct.client.gui.GuiWCT;
import p455w0rd.wct.client.render.BaubleRenderDispatcher;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.init.ModIntegration;
import p455w0rd.wct.init.ModItems;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.items.ItemMagnet;
import p455w0rd.wct.sync.packets.PacketConfigSync;
import p455w0rd.wct.sync.packets.PacketSyncInfinityEnergy;
import p455w0rd.wct.util.WCTUtils;
import p455w0rdslib.capabilities.CapabilityChunkLoader;
import p455w0rdslib.util.ChunkUtils;

public class ModEvents {
    public static long CLIENT_TICKS = 0L;
    public static long SERVER_TICKS = 0L;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
        ChunkUtils.register((Object)WCT.INSTANCE);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileController && ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER) {
            TileController controller = (TileController)event.getObject();
            event.addCapability(new ResourceLocation("wct", "chunkloader"), (ICapabilityProvider)new CapabilityChunkLoader.ProviderTE((TileEntity)controller));
        }
    }

    @SubscribeEvent
    public void onPlace(BlockEvent.PlaceEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && !world.field_72995_K && ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER && world.func_175625_s(pos) instanceof TileController && (tile = world.func_175625_s(pos)).hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).attachChunkLoader((Object)WCT.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && !world.field_72995_K && ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER && world.func_175625_s(pos) instanceof TileController && (tile = world.func_175625_s(pos)).hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).detachChunkLoader((Object)WCT.INSTANCE);
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent e) {
        ItemStack magnetItem;
        NBTTagCompound magCompound;
        NBTTagList tagList;
        NBTTagCompound magnetNBT;
        EntityPlayer player = e.player;
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack wirelessTerm = WCTUtils.getWirelessTerm(playerInv);
        int invSize = playerInv.func_70302_i_();
        if (invSize <= 0) {
            return;
        }
        if (player instanceof EntityPlayerMP && !ModConfig.USE_OLD_INFINTY_MECHANIC && !wirelessTerm.func_190926_b() && WCTUtils.shouldConsumeBoosters(wirelessTerm)) {
            for (int i = 0; i < invSize; ++i) {
                ItemStack slotStack = playerInv.func_70301_a(i);
                if (slotStack.func_190926_b() || slotStack.func_77973_b() != ModItems.BOOSTER_CARD) continue;
                WCTUtils.addInfinityBoosters(wirelessTerm, slotStack);
                ModNetworking.instance().sendTo(new PacketSyncInfinityEnergy(WCTUtils.getInfinityEnergy(wirelessTerm)), (EntityPlayerMP)player);
                playerInv.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
        if (!wirelessTerm.func_190926_b() && wirelessTerm.func_77942_o() && (magnetNBT = wirelessTerm.func_179543_a("MagnetSlot")) != null && (tagList = magnetNBT.func_150295_c("Items", 10)) != null && !tagList.func_82582_d() && (magCompound = tagList.func_150305_b(0)) != null && !(magnetItem = new ItemStack(magCompound)).func_190926_b() && magnetItem.func_77973_b() instanceof ItemMagnet) {
            ((ItemMagnet)magnetItem.func_77973_b()).setItemStack(magnetItem);
            ((ItemMagnet)magnetItem.func_77973_b()).doMagnet(magnetItem, WCTUtils.world(e.player), e.player, wirelessTerm);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (CLIENT_TICKS > 9223372036854774807L) {
                CLIENT_TICKS = 0L;
            }
            ++CLIENT_TICKS;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onKeyInput(InputEvent.KeyInputEvent e) {
        WCTUtils.handleKeybind();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseEvent(MouseEvent event) {
        WCTUtils.handleKeybind();
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        Random rand;
        int n;
        ItemStack stack = new ItemStack((Item)ModItems.BOOSTER_CARD);
        EntityItem drop = new EntityItem(event.getEntityLiving().func_130014_f_(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, stack);
        if (event.getEntity() instanceof EntityDragon && ModConfig.WCT_BOOSTER_ENABLED && ModConfig.WCT_DRAGON_DROPS_BOOSTER) {
            event.getDrops().add(drop);
        }
        if (event.getEntity() instanceof EntityWither && ModConfig.WCT_BOOSTER_ENABLED && ModConfig.WCT_WITHER_DROPS_BOOSTER && (n = (rand = event.getEntityLiving().func_130014_f_().field_73012_v).nextInt(100)) <= ModConfig.WCT_BOOSTER_DROP_CHANCE) {
            event.getDrops().add(drop);
        }
        if (event.getEntity() instanceof EntityEnderman && ModConfig.WCT_BOOSTER_ENABLED && ModConfig.WCT_ENDERMAN_DROP_BOOSTERS && (n = (rand = event.getEntityLiving().func_130014_f_().field_73012_v).nextInt(100)) <= ModConfig.WCT_ENDERMAN_BOOSTER_DROP_CHANCE) {
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            PacketConfigSync p = new PacketConfigSync(ModConfig.WCT_MAX_POWER, ModConfig.WCT_BOOSTER_ENABLED, ModConfig.WCT_MINETWEAKER_OVERRIDE, ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER, ModConfig.WCT_DRAGON_DROPS_BOOSTER);
            ModNetworking.instance().sendTo(p, (EntityPlayerMP)e.player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        if (ModIntegration.Mods.BAUBLES.isLoaded() && !BaubleRenderDispatcher.getRegistry().containsKey(event.getRenderer())) {
            event.getRenderer().func_177094_a((LayerRenderer)new BaubleRenderDispatcher(event.getRenderer()));
            BaubleRenderDispatcher.getRegistry().put(event.getRenderer(), null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onkeyTyped(GuiScreenEvent.KeyboardInputEvent.Post e) {
        Enum searchMode;
        if (ModIntegration.Mods.JEI.isLoaded() && Minecraft.func_71410_x().field_71462_r instanceof GuiWCT && ((searchMode = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE)) == SearchBoxMode.JEI_AUTOSEARCH || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH || searchMode == SearchBoxMode.JEI_AUTOSEARCH_KEEP || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH_KEEP)) {
            GuiWCT gui = (GuiWCT)Minecraft.func_71410_x().field_71462_r;
            String searchText = Integrations.jei().getSearchText();
            if (gui.getSearchField() != null) {
                gui.getRepo().setSearchString(searchText);
                gui.getRepo().updateView();
                gui.getSearchField().func_146180_a(searchText);
                GuiWCT.memoryText = searchText;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPickup(EntityItemPickupEvent e) {
        ItemStack wirelessTerminal;
        if (e.getEntityPlayer() != null && e.getEntityPlayer() instanceof EntityPlayerMP && !ModConfig.USE_OLD_INFINTY_MECHANIC && e.getItem().func_92059_d().func_77973_b() == ModItems.BOOSTER_CARD && !(wirelessTerminal = WCTUtils.getWirelessTerm(e.getEntityPlayer().field_71071_by)).func_190926_b() && WCTUtils.shouldConsumeBoosters(wirelessTerminal)) {
            e.setCanceled(true);
            ItemStack boosters = e.getItem().func_92059_d().func_77946_l();
            WCTUtils.addInfinityBoosters(wirelessTerminal, boosters);
            ModNetworking.instance().sendTo(new PacketSyncInfinityEnergy(WCTUtils.getInfinityEnergy(wirelessTerminal)), (EntityPlayerMP)e.getEntityPlayer());
            e.getItem().func_70106_y();
        }
    }
}

