/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.client.render;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class StackSizeRenderer {
    private static final ReadableNumberConverter CONVERTER = ReadableNumberConverter.INSTANCE;

    public void renderStackSize(FontRenderer fontRenderer, IAEItemStack aeStack, ItemStack is, int xPos, int yPos) {
        if (aeStack != null) {
            long amount;
            float scaleFactor = AEConfig.instance().useTerminalUseLargeFont() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            int offset = AEConfig.instance().useTerminalUseLargeFont() ? 0 : -1;
            boolean unicodeFlag = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(false);
            if (aeStack.getStackSize() == 0L && aeStack.isCraftable()) {
                String craftLabelText = AEConfig.instance().useTerminalUseLargeFont() ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                int X = (int)(((float)xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(craftLabelText) * scaleFactor) * inverseScaleFactor);
                int Y = (int)(((float)yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_175063_a(craftLabelText, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            long l = amount = aeStack != null ? aeStack.getStackSize() : (long)is.func_190916_E();
            if (aeStack.getStackSize() > 0L) {
                String stackSize = this.getToBeRenderedStackSize(amount);
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                int X = (int)(((float)xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
                int Y = (int)(((float)yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_175063_a(stackSize, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            fontRenderer.func_78264_a(unicodeFlag);
        }
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (AEConfig.instance().useTerminalUseLargeFont()) {
            return CONVERTER.toSlimReadableForm(originalSize);
        }
        return CONVERTER.toWideReadableForm(originalSize);
    }

    public static final class ReadableNumberConverter
    extends Enum<ReadableNumberConverter> {
        public static final /* enum */ ReadableNumberConverter INSTANCE = new ReadableNumberConverter();
        private static final String[] ENCODED_SUFFIXES;
        private final Format format;
        private static final /* synthetic */ ReadableNumberConverter[] $VALUES;

        public static ReadableNumberConverter[] values() {
            return (ReadableNumberConverter[])$VALUES.clone();
        }

        public static ReadableNumberConverter valueOf(String name) {
            return Enum.valueOf(ReadableNumberConverter.class, name);
        }

        private ReadableNumberConverter() {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            DecimalFormat format = new DecimalFormat(".#;0.#");
            format.setDecimalFormatSymbols(symbols);
            format.setRoundingMode(RoundingMode.DOWN);
            this.format = format;
        }

        public String toSlimReadableForm(long number) {
            return this.toReadableFormRestrictedByWidth(number, 3);
        }

        private String toReadableFormRestrictedByWidth(long number, int width) {
            String slimResult;
            assert (number >= 0L);
            String numberString = Long.toString(number);
            int numberSize = numberString.length();
            if (numberSize <= width) {
                return numberString;
            }
            long base = number;
            double last = base * 1000L;
            int exponent = -1;
            String postFix = "";
            while (numberSize > width) {
                last = base;
                numberSize = Long.toString(base /= 1000L).length() + 1;
                postFix = ENCODED_SUFFIXES[++exponent];
            }
            String withPrecision = this.format.format(last / 1000.0) + postFix;
            String withoutPrecision = Long.toString(base) + postFix;
            String string = slimResult = withPrecision.length() <= width ? withPrecision : withoutPrecision;
            assert (slimResult.length() <= width);
            return slimResult;
        }

        public String toWideReadableForm(long number) {
            return this.toReadableFormRestrictedByWidth(number, 4);
        }

        static {
            $VALUES = new ReadableNumberConverter[]{INSTANCE};
            ENCODED_SUFFIXES = new String[]{"K", "M", "B", "T", "Qa", "Qi"};
        }
    }
}

