/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_voidminer.renderer;

import com.valkyrieofnight.et.api.m_multiblocks.m_voidminer.IBLaserLens;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.tile.TileContVoidMinerBase;
import com.valkyrieofnight.vlib3.core.util.client.ColorUtil;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class TileVoidMinerRenderer
extends TileEntitySpecialRenderer<TileContVoidMinerBase> {
    public static final ResourceLocation TEXTURE_BEACON_BEAM = new ResourceLocation("environmentaltech:textures/entity/laser_beam.png");

    public void render(TileContVoidMinerBase te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.isFormed() && te.canSeeVoid()) {
            if (te.isProcessing()) {
                this.renderBeam(te, x, y, z, partialTicks, destroyStage, alpha);
            } else {
                this.renderBeamIdle(te, x, y, z, partialTicks, destroyStage, alpha);
            }
        }
    }

    private void renderBeam(TileContVoidMinerBase te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float[] color2;
        List laserLenses = te.getStructure().getSlavesOfType(IBLaserLens.class, te.func_174877_v(), te.getFormer().getMBDirectionE());
        int fistLength = 0;
        if (laserLenses.size() > 0) {
            fistLength = Math.abs(te.func_174877_v().func_177956_o() - ((BlockPos)laserLenses.get(0)).func_177956_o());
        }
        int scndLength = 2;
        if (te.getVoidPos() != null) {
            scndLength = te.func_174877_v().func_177956_o() - fistLength - te.getVoidPos().func_177956_o() + 1;
        }
        if ((color2 = te.getLaserColor()) == null) {
            color2 = EnumDyeColor.WHITE.func_193349_f();
        }
        this.func_147499_a(TEXTURE_BEACON_BEAM);
        TileVoidMinerRenderer.renderBeamSegment(x, y - 0.5, z, partialTicks, 1.0, te.getTheWorld().func_82737_E(), 0, 1 - fistLength, new float[]{1.0f, 1.0f, 1.0f}, 0.25, 0.3);
        TileVoidMinerRenderer.renderBeamSegment(x, y + 0.5 - (double)fistLength, z, partialTicks, 1.0, te.getTheWorld().func_82737_E(), 0, 1 - scndLength, color2, 0.2, 0.3);
    }

    private void renderBeamIdle(TileContVoidMinerBase te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float[] color2;
        List laserLenses = te.getStructure().getSlavesOfType(IBLaserLens.class, te.func_174877_v(), te.getFormer().getMBDirectionE());
        int fistLength = 0;
        if (laserLenses.size() > 0) {
            fistLength = Math.abs(te.func_174877_v().func_177956_o() - ((BlockPos)laserLenses.get(0)).func_177956_o());
        }
        int scndLength = 2;
        if (te.getVoidPos() != null) {
            scndLength = te.func_174877_v().func_177956_o() - fistLength - te.getVoidPos().func_177956_o() + 1;
        }
        if ((color2 = te.getLaserColor()) == null) {
            color2 = EnumDyeColor.WHITE.func_193349_f();
        }
        this.func_147499_a(TEXTURE_BEACON_BEAM);
        this.func_190053_a(true);
        TileVoidMinerRenderer.renderBeamSegment(x, y - 0.5, z, partialTicks, 1.0, te.getTheWorld().func_82737_E(), 0, 1 - fistLength, new float[]{1.0f, 1.0f, 1.0f}, 0.0625, 0.125);
        TileVoidMinerRenderer.renderBeamSegment(x, y + 0.5 - (double)fistLength, z, partialTicks, 1.0, te.getTheWorld().func_82737_E(), 0, 1 - scndLength, color2, 0.06, 0.125);
    }

    public static float[] getColor(int mcColor) {
        return new float[]{ColorUtil.getRF((int)mcColor), ColorUtil.getGF((int)mcColor), ColorUtil.getBF((int)mcColor)};
    }

    public static void renderBeamSegment(double x, double y, double z, double partialTicks, double beamRenderScale, double worldTime, int lastHeight, int height, float[] colors, double par10, double par11) {
        int i = lastHeight + height;
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        double d0 = worldTime + partialTicks;
        double d1 = height < 0 ? d0 : -d0;
        double d2 = MathHelper.func_181162_h((double)(d1 * 0.2 - (double)MathHelper.func_76128_c((double)(d1 * 0.1))));
        float f = colors[0];
        float f1 = colors[1];
        float f2 = colors[2];
        double d3 = d0 * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d3 + 2.356194490192345) * par10;
        double d5 = 0.5 + Math.sin(d3 + 2.356194490192345) * par10;
        double d6 = 0.5 + Math.cos(d3 + 0.7853981633974483) * par10;
        double d7 = 0.5 + Math.sin(d3 + 0.7853981633974483) * par10;
        double d8 = 0.5 + Math.cos(d3 + 3.9269908169872414) * par10;
        double d9 = 0.5 + Math.sin(d3 + 3.9269908169872414) * par10;
        double d10 = 0.5 + Math.cos(d3 + 5.497787143782138) * par10;
        double d11 = 0.5 + Math.sin(d3 + 5.497787143782138) * par10;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = -1.0 + d2;
        double d15 = (double)height * beamRenderScale * (0.5 / par10) + d14;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b(x + d4, y + (double)i, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d4, y + (double)lastHeight, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d6, y + (double)lastHeight, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d6, y + (double)i, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d10, y + (double)i, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d10, y + (double)lastHeight, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d8, y + (double)lastHeight, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d8, y + (double)i, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d6, y + (double)i, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d6, y + (double)lastHeight, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d10, y + (double)lastHeight, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d10, y + (double)i, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d8, y + (double)i, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d8, y + (double)lastHeight, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d4, y + (double)lastHeight, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(x + d4, y + (double)i, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)false);
        d3 = 0.5 - par11;
        d4 = 0.5 - par11;
        d5 = 0.5 + par11;
        d6 = 0.5 - par11;
        d7 = 0.5 - par11;
        d8 = 0.5 + par11;
        d9 = 0.5 + par11;
        d10 = 0.5 + par11;
        d11 = 0.0;
        d12 = 1.0;
        d13 = -1.0 + d2;
        d14 = (double)height * beamRenderScale + d13;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b(x + d3, y + (double)i, z + d4).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d3, y + (double)lastHeight, z + d4).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + (double)lastHeight, z + d6).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + (double)i, z + d6).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + (double)i, z + d10).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + (double)lastHeight, z + d10).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + (double)lastHeight, z + d8).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + (double)i, z + d8).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + (double)i, z + d6).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + (double)lastHeight, z + d6).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + (double)lastHeight, z + d10).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + (double)i, z + d10).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + (double)i, z + d8).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + (double)lastHeight, z + d8).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d3, y + (double)lastHeight, z + d4).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        vertexbuffer.func_181662_b(x + d3, y + (double)i, z + d4).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    public boolean isGlobalRenderer(TileContVoidMinerBase te) {
        return true;
    }
}

