/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.ITargetableRegistry;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.json.JsonTargetedStack;
import com.valkyrieofnight.vlib.lib.stack.WeightedStackBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class TargetableJsonHandler {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void saveRegistryDefaultsToJson(File file, ArrayList<JsonTargetedStack> list) {
        JTSList obj = new JTSList();
        obj.outputs = list;
        try {
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            writer.write(gson.toJson((Object)obj));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList loadRegistryFromJson(File file, ITargetableRegistry registry) {
        ArrayList<JsonTargetedStack> loaded = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            if (reader.ready()) {
                JTSList obj = (JTSList)gson.fromJson((Reader)reader, JTSList.class);
                loaded = obj.outputs;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (loaded != null) {
            TargetableJsonHandler.loadIntoRegistry(loaded, registry);
        }
        return loaded;
    }

    public static void loadIntoRegistry(ArrayList<JsonTargetedStack> entries, ITargetableRegistry registry) {
        if (entries == null || registry == null) {
            return;
        }
        for (JsonTargetedStack jts : entries) {
            List<WeightedStackBase> wsl = jts.getRegistryEntries();
            if (wsl == null || wsl.isEmpty()) continue;
            String target = jts.getTarget();
            for (WeightedStackBase ws : wsl) {
                if (ws.getMainStack() == null || ws.getMainStack() == ItemStack.field_190927_a || ws.getMainStack().func_77973_b() == null || ws.getMainStack().func_190916_E() <= 0 || ws.getWeight() <= 0) continue;
                registry.addResource(ws, target);
            }
        }
    }

    private static class JTSList {
        ArrayList<JsonTargetedStack> outputs;

        private JTSList() {
        }
    }
}

