/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_solar.tile;

import com.valkyrieofnight.et.api.m_multiblocks.ITEfficiency;
import com.valkyrieofnight.et.api.m_multiblocks.m_components.m_modifiers.ETModifierAttributes;
import com.valkyrieofnight.et.api.m_multiblocks.m_solararray.ITSolarController;
import com.valkyrieofnight.et.base.tile.ETControllerEProducer;
import com.valkyrieofnight.et.m_multiblocks.m_solar.block.BlockSolarCell;
import com.valkyrieofnight.vlib.api.multiblock.structure.IStructureComponent;
import com.valkyrieofnight.vlib.lib.multiblock.structure.MultiBlockStructure;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public abstract class TileContSolarBase
extends ETControllerEProducer
implements ITSolarController {
    protected static final String T_FE_PER_CELL = "fe_gen_per_cell";
    protected static final String T_FE_PEAK_LITHERITE = "t_peak_fe_litherite";
    protected static final String T_FE_PEAK_AETHIUM = "t_peak_fe_aethium";
    public static int BASE_DURATION = 10;
    public static int PRODUCTION_RATE = 128;
    public static double PRODUCTION_POWER = 2.0;
    public static EnumFacing[] OUTPUT_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.DOWN};
    protected ContinuousSolarScanner solarScanner;
    protected int totalValidCells = 0;
    protected float efficiency = 0.0f;

    public static int getMultiplier(int tier) {
        if (tier <= 0) {
            return 1;
        }
        return (int)Math.pow(PRODUCTION_POWER, tier - 1);
    }

    public static int getCellGen(int tier) {
        return PRODUCTION_RATE * TileContSolarBase.getMultiplier(tier);
    }

    public static int getArrayGen(int tier, int totalCells) {
        return TileContSolarBase.getCellGen(tier) * totalCells;
    }

    public static int getTotalRFForEfficiency(float eff, float maxEff, int totalCells, int rfpercell) {
        int cellrf = (int)((float)rfpercell * Math.min(eff, maxEff));
        int total = cellrf * totalCells;
        return total;
    }

    public static MultiBlockStructure createCustomPanel(MultiBlockStructure structure, IStructureComponent structureBlock, IStructureComponent cellBlock, int panelTier) {
        int panelHalf = panelTier + 1;
        for (int x = -panelHalf; x < panelHalf + 1; ++x) {
            for (int z = -panelHalf; z < panelHalf + 1; ++z) {
                if (x == -panelHalf || z == -panelHalf || x == panelHalf || z == panelHalf) {
                    structure.addRequiredBlock(structureBlock, x, 1, z);
                    continue;
                }
                structure.addRequiredBlock(cellBlock, x, 1, z);
            }
        }
        return structure;
    }

    public TileContSolarBase(int rft) {
        super(BASE_DURATION * rft);
    }

    public String getInfo() {
        return super.getInfo() + " FE/T: " + this.getTotalEnergyPerTick();
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 4;
    }

    @Override
    public void updateTile() {
        super.updateTile();
        if (!this.getTheWorld().field_72995_K && this.isFormed()) {
            if (this.solarScanner == null) {
                this.solarScanner = new ContinuousSolarScanner(this, this.getScanRate());
            }
            this.solarScanner.update();
        }
    }

    protected abstract int getScanRate();

    public EnumFacing[] validEnergyDirections() {
        return OUTPUT_DIRECTIONS;
    }

    public void onProcessComplete() {
    }

    protected void genEnergy() {
        this.eBuffer.iReceiveFE(this.getTotalEnergyPerTick(), false);
    }

    public int getTotalEnergyPerTick() {
        int totalRF = 0;
        if (this.getTheWorld().func_72935_r()) {
            totalRF = (int)((float)totalRF + (float)(this.getCellRFT() * this.totalValidCells) * this.getTheWorld().getSunBrightnessFactor(1.0f));
        }
        if ((this.getTheWorld().func_72896_J() || this.getTheWorld().func_72911_I()) && this.modifierHandler.hasAttribute(ETModifierAttributes.PIEZO_1_ID)) {
            int addRF = this.getCellRFT() * this.totalValidCells / 64;
            addRF = (Integer)ETModifierAttributes.PIEZO_1_ID.getCalculator().calculateModifiedValue(this.modifierHandler.getAttributeFinalValue(ETModifierAttributes.PIEZO_1_ID), (Object)addRF);
            addRF = (int)((float)addRF * this.getTheWorld().func_72867_j(1.0f) * (1.0f + this.getTheWorld().func_72819_i(2.0f)));
            totalRF += addRF;
        }
        return totalRF;
    }

    protected int getCellRFT() {
        return (int)((float)this.getRFPerCell() * this.efficiency);
    }

    protected abstract int getRFPerCell();

    public int getBaseDuration() {
        return BASE_DURATION;
    }

    public int modifyDuration(int unmodifiedDuration) {
        return unmodifiedDuration;
    }

    protected void setValidSolarsAndEfficiency(int valid, float efficiency) {
        this.totalValidCells = valid;
        this.efficiency = efficiency;
    }

    protected List<BlockPos> getAllCells() {
        return this.getStructure().getSlavesOfType(BlockSolarCell.class, this.func_174877_v(), this.former.getMBDirectionE());
    }

    public void onProcessStart() {
    }

    public void onProcessTick(int processedTicks) {
        this.genEnergy();
    }

    public void onIdleTick() {
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    protected static class ContinuousSolarScanner {
        private TileContSolarBase solarCont;
        private Queue<BlockPos> queue = new LinkedList<BlockPos>();
        private World world;
        private int scanRate;
        private int totalValid = 0;
        private float totalEfficiency = 0.0f;

        public ContinuousSolarScanner(TileContSolarBase cont, int scanRate) {
            this.solarCont = cont;
            this.scanRate = scanRate;
            this.world = cont.getTheWorld();
        }

        public void update() {
            for (int i = 0; i < this.scanRate; ++i) {
                if (!this.checkValid()) continue;
                ++this.totalValid;
            }
        }

        protected boolean checkValid() {
            if (this.queue.isEmpty()) {
                this.startQueue();
                return false;
            }
            BlockPos pos = this.queue.poll();
            if (!this.world.func_175710_j(pos.func_177972_a(EnumFacing.UP))) {
                return false;
            }
            TileEntity cell = this.world.func_175625_s(pos);
            if (cell instanceof ITEfficiency) {
                ITEfficiency cellE = (ITEfficiency)cell;
                this.totalEfficiency += ((ITEfficiency)cell).getEfficiencyMultiplier();
            }
            return true;
        }

        public void setScanRate(int scanRate) {
            this.scanRate = scanRate;
        }

        protected void startQueue() {
            this.solarCont.setValidSolarsAndEfficiency(this.totalValid, Math.min(this.totalEfficiency / (float)this.totalValid, this.solarCont.getEfficiencyMaxMultiplier()));
            this.totalEfficiency = 0.0f;
            this.totalValid = 0;
            this.queue.clear();
            this.queue.addAll(this.solarCont.getAllCells());
        }
    }
}

