/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager.old;

import com.valkyrieofnight.et.base.IETNamespace;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager.old.NBBPlayerDataOld;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfo;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfoRegistry;
import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.base.NamespaceLocation;
import com.valkyrieofnight.vlib.lib.sys.owner.Owner;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class NBBWorldData
extends WorldSavedData
implements IETNamespace {
    private static final String DATA_NAME = "environmentaltech_nanobotdata";
    protected volatile Map<BeaconInfo, Map<Owner, NBBPlayerDataOld>> DATA = new HashMap<BeaconInfo, Map<Owner, NBBPlayerDataOld>>();

    public NBBWorldData(String name) {
        super(name);
    }

    public NBBWorldData() {
        super(DATA_NAME);
    }

    public void queueDisable(BeaconInfo bi, Owner owner, AttributeCache cache) {
        if (owner == Owner.NO_OWNER) {
            return;
        }
        if (cache == null) {
            return;
        }
        System.out.println(bi + " " + owner.toString() + " " + cache.toString());
        Minecraft.func_71410_x().func_152344_a(() -> {
            NBBPlayerDataOld pd = this.getPlayerData(bi, owner);
            pd.queueDisable(cache);
        });
    }

    public void removeDisable(BeaconInfo bi, Owner owner, AttributeCache cache) {
        if (owner != Owner.NO_OWNER) {
            return;
        }
        if (cache == null) {
            return;
        }
        Minecraft.func_71410_x().func_152344_a(() -> {
            NBBPlayerDataOld pd = this.getPlayerData(bi, owner);
            pd.removeQueued(cache.getAttribute());
        });
    }

    public NBBPlayerDataOld getPlayerData(BeaconInfo bi, Owner owner) {
        NBBPlayerDataOld pd;
        Map<Owner, NBBPlayerDataOld> pdm = this.DATA.get(bi);
        if (pdm == null || pdm.isEmpty()) {
            pdm = new HashMap<Owner, NBBPlayerDataOld>();
            this.DATA.put(bi, pdm);
        }
        if ((pd = pdm.get(owner)) == null) {
            pd = new NBBPlayerDataOld(owner);
            pdm.put(owner, pd);
        }
        return pd;
    }

    public void worldTick(World world) {
        if (world.func_82737_E() % 20L == 0L) {
            for (BeaconInfo bi : this.DATA.keySet()) {
                Map<Owner, NBBPlayerDataOld> playerData = this.DATA.get(bi);
                for (Owner gp : playerData.keySet()) {
                    NBBPlayerDataOld nbbPD = playerData.get(gp);
                    if (nbbPD == null) continue;
                    nbbPD.checkDisable(bi, world);
                }
            }
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList data = nbt.func_150295_c("nanobotdata", 10);
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound beaconInfoData = data.func_150305_b(i);
            NamespaceLocation beaconName = NamespaceLocation.fromString((String)beaconInfoData.func_74779_i("beacon_name"));
            BeaconInfo bi = BeaconInfoRegistry.getInstance().getBeaconInfo(beaconName);
            HashMap<Owner, NBBPlayerDataOld> beaconPlayerData = new HashMap<Owner, NBBPlayerDataOld>();
            NBTTagList playerDataList = beaconInfoData.func_150295_c("player_data", 10);
            for (int j = 0; j < playerDataList.func_74745_c(); ++j) {
                NBTTagCompound tagPD = playerDataList.func_150305_b(j);
                NBBPlayerDataOld nbbPD = new NBBPlayerDataOld();
                nbbPD.readFromNBT(tagPD);
                beaconPlayerData.put(nbbPD.getOwner(), nbbPD);
            }
            this.DATA.put(bi, beaconPlayerData);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList data = new NBTTagList();
        for (BeaconInfo bi : this.DATA.keySet()) {
            NBTTagCompound beaconInfoData = new NBTTagCompound();
            beaconInfoData.func_74778_a("beacon_name", bi.getNamespaceLocation().toString());
            NBTTagList nbbPlayerDataList = new NBTTagList();
            for (Owner gp : this.DATA.get(bi).keySet()) {
                NBBPlayerDataOld pd = this.DATA.get(bi).get(gp);
                NBTTagCompound playerData = new NBTTagCompound();
                pd.writeToNBT(playerData);
                nbbPlayerDataList.func_74742_a((NBTBase)playerData);
            }
            beaconInfoData.func_74782_a("player_data", (NBTBase)nbbPlayerDataList);
            data.func_74742_a((NBTBase)beaconInfoData);
        }
        compound.func_74782_a("nanobotdata", (NBTBase)data);
        return compound;
    }

    public static NBBWorldData getNBBWorldData(World world) {
        MapStorage ms = world.func_175693_T();
        NBBWorldData data = (NBBWorldData)ms.func_75742_a(NBBWorldData.class, DATA_NAME);
        if (data == null) {
            data = new NBBWorldData(DATA_NAME);
            ms.func_75745_a(DATA_NAME, (WorldSavedData)data);
        }
        return data;
    }
}

