/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager;

import com.valkyrieofnight.et.m_multiblocks.m_nanobot.applicator.IAttributeApplicator;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager.NBBManagerData;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfo;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfoRegistry;
import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.AttributeIDRegistry;
import com.valkyrieofnight.um.api.base.NamespaceLocation;
import com.valkyrieofnight.vlib.lib.sys.owner.Owner;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class NBBPlayerData {
    public NBBManagerData manager;
    protected Owner owner;
    protected volatile ConcurrentMap<BeaconInfo, Queue<AttributeCache>> queues = new ConcurrentHashMap<BeaconInfo, Queue<AttributeCache>>();

    public NBBPlayerData(NBBManagerData manager, Owner owner) {
        this.manager = manager;
        this.owner = owner;
    }

    public void addToQueue(@Nonnull BeaconInfo bi, @Nonnull AttributeCache cache) {
        AttributeCache[] qa;
        this.manager.func_76185_a();
        Queue q = this.getQueue(bi);
        boolean removed = false;
        int count = 0;
        for (AttributeCache attributeCache : qa = q.toArray(new AttributeCache[0])) {
            if (attributeCache.getAttribute() != cache.getAttribute()) continue;
            ++count;
            if (attributeCache.getAttribute().getCalculator().getLargerFinalValue(attributeCache.getFinalValue(), cache.getFinalValue()) != 2) continue;
            q.remove(attributeCache);
            removed = true;
        }
        if (removed || count == 0) {
            q.add(cache);
        }
    }

    public void removeFromQueue(@Nonnull BeaconInfo bi, @Nonnull AttributeCache cache) {
        AttributeCache[] qa;
        this.manager.func_76185_a();
        Queue q = this.getQueue(bi);
        for (AttributeCache attributeCache : qa = q.toArray(new AttributeCache[0])) {
            if (attributeCache.getAttribute() != cache.getAttribute() || attributeCache.getAttribute().getCalculator().getLargerFinalValue(attributeCache.getFinalValue(), cache.getFinalValue()) != 2) continue;
            q.remove(attributeCache);
        }
    }

    private Queue getQueue(@Nonnull BeaconInfo bi) {
        Queue r = (Queue)this.queues.get(bi);
        if (r == null) {
            this.queues.putIfAbsent(bi, new ConcurrentLinkedQueue());
            r = (Queue)this.queues.get(bi);
        }
        return r;
    }

    public void tick(World world) {
        if (world.func_82737_E() % 20L == 0L) {
            if (this.owner == Owner.NO_OWNER) {
                return;
            }
            EntityPlayer ep = this.owner.getFromWorld(world);
            if (ep == null) {
                return;
            }
            for (BeaconInfo bi : this.queues.keySet()) {
                IAttributeApplicator app;
                Queue q = this.getQueue(bi);
                AttributeCache a = (AttributeCache)q.peek();
                if (a == null || !(app = bi.getApplicatorRegistry().getApplicator(a.getAttribute())).onDisableAttribute(a, world, ep)) continue;
                q.remove(a);
            }
        }
    }

    public NBBPlayerData readFromNBT(NBTTagCompound nbt) {
        NBTTagList data = nbt.func_150295_c("data", 10);
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound beaconData = data.func_150305_b(i);
            NamespaceLocation beaconName = NamespaceLocation.fromString((String)beaconData.func_74779_i("beacon_name"));
            BeaconInfo bi = BeaconInfoRegistry.getInstance().getBeaconInfo(beaconName);
            ConcurrentLinkedQueue<AttributeCache> q = new ConcurrentLinkedQueue<AttributeCache>();
            NBTTagList dataAttr = beaconData.func_150295_c("attributes", 10);
            for (int j = 0; j < dataAttr.func_74745_c(); ++j) {
                NBTTagCompound atn = dataAttr.func_150305_b(j);
                AttributeID atid = AttributeIDRegistry.getInstance().getAttributeIDFromString(atn.func_74779_i("id"));
                q.add(new AttributeCache(atid, atid.getCalculator().readFinalValueFromNBT(atn)));
            }
            if (bi == null || q == null) continue;
            this.queues.putIfAbsent(bi, q);
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList data = new NBTTagList();
        for (BeaconInfo bi : this.queues.keySet()) {
            NBTTagCompound beaconData = new NBTTagCompound();
            beaconData.func_74778_a("beacon_name", bi.getNamespaceLocation().toString());
            NBTTagList dataAttr = new NBTTagList();
            Queue q = this.getQueue(bi);
            for (AttributeCache att : q) {
                NBTTagCompound atn = new NBTTagCompound();
                atn.func_74778_a("id", att.getAttribute().toString());
                att.getAttribute().getCalculator().writeFinalValueToNBT(atn, att.getFinalValue());
                dataAttr.func_74742_a((NBTBase)atn);
            }
            beaconData.func_74782_a("attributes", (NBTBase)dataAttr);
            data.func_74742_a((NBTBase)beaconData);
        }
        nbt.func_74782_a("data", (NBTBase)data);
        return nbt;
    }
}

