/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager;

import com.valkyrieofnight.et.base.IETNamespace;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager.NBBPlayerData;
import com.valkyrieofnight.vlib.lib.sys.owner.Owner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class NBBManagerData
extends WorldSavedData
implements IETNamespace {
    private static final String DATA_NAME = "environmentaltech_nanobotdata";
    protected volatile ConcurrentMap<Owner, NBBPlayerData> DATA = new ConcurrentHashMap<Owner, NBBPlayerData>();

    public NBBManagerData(String name) {
        super(name);
    }

    public NBBManagerData() {
        super(DATA_NAME);
    }

    public NBBPlayerData getPlayerData(Owner owner) {
        NBBPlayerData pd = (NBBPlayerData)this.DATA.get(owner);
        if (pd == null) {
            this.DATA.putIfAbsent(owner, new NBBPlayerData(this, owner));
            pd = (NBBPlayerData)this.DATA.get(owner);
        }
        return pd;
    }

    public void worldTick(World world) {
        for (Owner o : this.DATA.keySet()) {
            NBBPlayerData pd = this.getPlayerData(o);
            if (o == Owner.NO_OWNER || o.getOwnerUUID() == null) {
                this.DATA.remove(o);
            }
            pd.tick(world);
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList data = nbt.func_150295_c("nanobotdata", 10);
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound playerData = data.func_150305_b(i);
            Owner o = Owner.getFromNBT((NBTTagCompound)playerData.func_74775_l("owner"));
            NBTTagCompound playerAttr = playerData.func_74775_l("data");
            NBBPlayerData pd = new NBBPlayerData(this, o);
            pd.readFromNBT(playerAttr);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList data = new NBTTagList();
        for (Owner owner : this.DATA.keySet()) {
            NBTTagCompound playerData = new NBTTagCompound();
            playerData.func_74782_a("owner", (NBTBase)owner.serializeNBT());
            NBTTagCompound playerAttr = new NBTTagCompound();
            NBBPlayerData pd = (NBBPlayerData)this.DATA.get(owner);
            pd.writeToNBT(playerAttr);
            playerData.func_74782_a("data", (NBTBase)playerAttr);
            data.func_74742_a((NBTBase)playerData);
        }
        nbt.func_74782_a("nanobotdata", (NBTBase)data);
        return nbt;
    }

    public static NBBManagerData getNBBWorldData(World world) {
        MapStorage ms = world.func_175693_T();
        NBBManagerData data = (NBBManagerData)ms.func_75742_a(NBBManagerData.class, DATA_NAME);
        if (data == null) {
            data = new NBBManagerData(DATA_NAME);
            ms.func_75745_a(DATA_NAME, (WorldSavedData)data);
        }
        return data;
    }
}

