/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_lightningrod.tile;

import com.valkyrieofnight.et.base.tile.ETControllerEProducer;
import com.valkyrieofnight.vlib3.core.util.MathUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

public abstract class TileContLightningBase
extends ETControllerEProducer {
    protected static String T_FE_MIN = "fe_gen_min";
    protected static String T_FE_MAX = "fe_gen_max";
    protected static String T_STRIKE_CHANCE = "strike_chance";
    public static int PRODUCTION_RATE = 750000;
    public static double PRODUCTION_POWER = 3.8;
    public static int THUNDER_DURATION_MAX = 800;
    public static EnumFacing[] OUTPUT_DIRECTIONS = new EnumFacing[]{EnumFacing.DOWN};
    private int thisDuration = 0;
    private final int maxFEPulse;
    private BlockPos rodTop;

    public static int getMultiplier(int tier) {
        if (tier <= 0) {
            return 1;
        }
        return (int)Math.pow(PRODUCTION_POWER, tier - 1);
    }

    public static int getRodGen(int tier) {
        return PRODUCTION_RATE * TileContLightningBase.getMultiplier(tier);
    }

    public static int getThunderDurationMin(int max) {
        return max / 2;
    }

    public static int getOtherDurationMax() {
        return THUNDER_DURATION_MAX * 4;
    }

    public static int getOtherDurationMin() {
        return TileContLightningBase.getThunderDurationMin(TileContLightningBase.getOtherDurationMax());
    }

    public static int getMinRFPulse(int max) {
        return max / 8;
    }

    public TileContLightningBase(int maxFEPulse) {
        super(maxFEPulse);
        this.maxFEPulse = maxFEPulse;
    }

    public void onProcessStart() {
        this.thisDuration = this.getTheWorld().func_72911_I() ? MathUtil.getRandomRange((Random)new Random(), (int)TileContLightningBase.getThunderDurationMin(this.getThunderDurationMax()), (int)this.getThunderDurationMax()) : MathUtil.getRandomRange((Random)new Random(), (int)TileContLightningBase.getThunderDurationMin(this.getNormalDurationMax()), (int)this.getNormalDurationMax());
    }

    public void onProcessTick(int processedTicks) {
        if (this.field_145850_b.func_72911_I() && this.progress.getDuration() > this.getThunderDurationMax()) {
            this.startNewProcess();
        }
        if (this.rodTop == null) {
            int highestY = 0;
            for (BlockPos blockPos : this.getStructure().getSlavesLayout(this.getTheWorld(), this.func_174877_v(), this.former.getMBDirectionE())) {
                if (blockPos.func_177956_o() <= highestY) continue;
                highestY = blockPos.func_177956_o();
                this.rodTop = blockPos;
            }
        }
    }

    public void onProcessComplete() {
        Random rand = new Random();
        if (rand.nextInt(100) < this.getChance()) {
            BlockPos top = this.rodTop;
            this.getTheWorld().func_72942_c((Entity)new EntityLightningBolt(this.getTheWorld(), (double)top.func_177958_n(), (double)top.func_177956_o(), (double)top.func_177952_p(), false));
            this.eBuffer.iReceiveFE(MathUtil.getRandomRange((Random)rand, (int)TileContLightningBase.getMinRFPulse(this.maxFEPulse), (int)this.maxFEPulse), false);
        }
    }

    public void onIdleTick() {
    }

    public int getBaseDuration() {
        return this.thisDuration;
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    public int modifyDuration(int unmodifiedDuration) {
        return unmodifiedDuration;
    }

    @Override
    public boolean canProcess() {
        return true;
    }

    public EnumFacing[] validEnergyDirections() {
        return OUTPUT_DIRECTIONS;
    }

    public int getThunderDurationMax() {
        return THUNDER_DURATION_MAX;
    }

    public abstract int getChance();

    public int getNormalDurationMax() {
        return this.getThunderDurationMax() * 4;
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 4;
    }
}

