/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.integration.computers;

import java.util.Optional;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mcjty.deepresonance.blocks.pedestal.PedestalTileEntity;
import mcjty.lib.integration.computers.AbstractOCDriver;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PedestalDriver {

    public static class OCDriver
    extends AbstractOCDriver {
        public OCDriver() {
            super("deepresonance_pedastal", PedestalTileEntity.class);
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            return new InternalManagedEnvironment((PedestalTileEntity)tile);
        }

        public static class InternalManagedEnvironment
        extends AbstractOCDriver.InternalManagedEnvironment<PedestalTileEntity> {
            public InternalManagedEnvironment(PedestalTileEntity tile) {
                super((Object)tile, "deepresonance_pedastal");
            }

            @Callback(doc="function():boolean; Returns whether there is a crystal on the pedestal.")
            public Object[] crystalPresent(Context c, Arguments a) {
                return new Object[]{((PedestalTileEntity)((Object)this.tile)).crystalPresent()};
            }

            @Callback(doc="function(); Drops the crystal on the pedestal.")
            public Object[] dropCrystal(Context c, Arguments a) {
                ((PedestalTileEntity)((Object)this.tile)).dropCrystal();
                return new Object[0];
            }

            @Callback(doc="function():number; Returns the purity of the crystal on the pedestal.")
            public Object[] getPurity(Context c, Arguments a) {
                Optional<Float> purity = ((PedestalTileEntity)((Object)this.tile)).getCrystal().map(cr -> Float.valueOf(cr.getPurity()));
                if (purity.isPresent()) {
                    return new Object[]{Float.valueOf(purity.get().floatValue())};
                }
                return new Object[]{null, "No crystal present"};
            }

            @Callback(doc="function():number; Returns the strength of the crystal on the pedestal.")
            public Object[] getStrength(Context c, Arguments a) {
                Optional<Float> strength = ((PedestalTileEntity)((Object)this.tile)).getCrystal().map(cr -> Float.valueOf(cr.getStrength()));
                if (strength.isPresent()) {
                    return new Object[]{Float.valueOf(strength.get().floatValue())};
                }
                return new Object[]{null, "No crystal present"};
            }

            @Callback(doc="function():number; Returns the efficiency of the crystal on the pedestal.")
            public Object[] getEfficiency(Context c, Arguments a) {
                Optional<Float> efficiency = ((PedestalTileEntity)((Object)this.tile)).getCrystal().map(cr -> Float.valueOf(cr.getEfficiency()));
                if (efficiency.isPresent()) {
                    return new Object[]{Float.valueOf(efficiency.get().floatValue())};
                }
                return new Object[]{null, "No crystal present"};
            }

            @Callback(doc="function():number; Returns the power left in the crystal on the pedestal.")
            public Object[] getPower(Context c, Arguments a) {
                Optional<Float> power = ((PedestalTileEntity)((Object)this.tile)).getCrystal().map(cr -> Float.valueOf(cr.getPower()));
                if (power.isPresent()) {
                    return new Object[]{Float.valueOf(power.get().floatValue())};
                }
                return new Object[]{null, "No crystal present"};
            }

            @Callback(doc="function():number; Returns the RF output of the crystal on the pedestal in RF/tick.")
            public Object[] getOutput(Context c, Arguments a) {
                Optional<Integer> output = ((PedestalTileEntity)((Object)this.tile)).getCrystal().map(cr -> cr.getRfPerTick());
                if (output.isPresent()) {
                    return new Object[]{(int)output.get()};
                }
                return new Object[]{null, "No crystal present"};
            }

            @Callback(doc="function():number; Returns whether the crystal on the pedestal is currently in use.")
            public Object[] isInUse(Context c, Arguments a) {
                Optional<Boolean> inUse = ((PedestalTileEntity)((Object)this.tile)).getCrystal().map(cr -> cr.isGlowing());
                if (inUse.isPresent()) {
                    return new Object[]{(boolean)inUse.get()};
                }
                return new Object[]{null, "No crystal present"};
            }

            public int priority() {
                return 4;
            }
        }
    }
}

