/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance;

import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.blocks.sensors.AbstractSensorTileEntity;
import mcjty.deepresonance.crafting.ModCrafting;
import mcjty.deepresonance.items.ModItems;
import mcjty.deepresonance.items.rftoolsmodule.RFToolsSupport;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationShieldRegistry;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.DamageMetadataItemBlock;
import mcjty.lib.network.PacketFinalizeLogin;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        McJtyRegister.registerBlocks((ModBase)DeepResonance.instance, (IForgeRegistry)event.getRegistry());
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.denseGlassBlock);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.denseObsidianBlock);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.debugBlock);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.poisonedDirtBlock);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.machineFrame);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.resonatingPlateBlock);
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.resonatingOreBlock);
        if (DeepResonance.instance.rftools) {
            event.getRegistry().register((IForgeRegistryEntry)RFToolsSupport.getRadiationSensorBlock());
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        McJtyRegister.registerItems((ModBase)DeepResonance.instance, (IForgeRegistry)event.getRegistry());
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.denseGlassBlock).setRegistryName(ModBlocks.denseGlassBlock.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.denseObsidianBlock).setRegistryName(ModBlocks.denseObsidianBlock.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.debugBlock).setRegistryName(ModBlocks.debugBlock.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.poisonedDirtBlock).setRegistryName(ModBlocks.poisonedDirtBlock.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.machineFrame).setRegistryName(ModBlocks.machineFrame.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.resonatingPlateBlock).setRegistryName(ModBlocks.resonatingPlateBlock.getRegistryName()));
        event.getRegistry().register(new DamageMetadataItemBlock((Block)ModBlocks.resonatingOreBlock).setRegistryName(ModBlocks.resonatingOreBlock.getRegistryName()));
        if (DeepResonance.instance.rftools) {
            event.getRegistry().register(new ItemBlock(RFToolsSupport.getRadiationSensorBlock()).setRegistryName(RFToolsSupport.getRadiationSensorBlock().getRegistryName()));
        }
        event.getRegistry().register((IForgeRegistryEntry)ModItems.boots);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.helmet);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.chestplate);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.leggings);
        ModCrafting.init();
        OreDictionary.registerOre((String)"oreResonating", (Block)ModBlocks.resonatingOreBlock);
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> sounds) {
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("deepresonance")) {
            ConfigManager.sync((String)"deepresonance", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        float blocker = RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        World world = event.getWorld();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalCoordinate, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getPos().func_177958_n();
        int y = event.getPos().func_177956_o();
        int z = event.getPos().func_177952_p();
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalCoordinate gc = entry.getKey();
            BlockPos c = gc.getCoordinate();
            if (!((float)Math.abs(c.func_177958_n() - x) < radius) || !((float)Math.abs(c.func_177956_o() - y) < radius) || !((float)Math.abs(c.func_177952_p() - z) < radius)) continue;
            Logging.logDebug((String)("Removed blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
            radiationTree.addBlocker(x, y, z, 1.0f);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        float blocker = RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        World world = event.getBlockSnapshot().getWorld();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalCoordinate, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getBlockSnapshot().getPos().func_177958_n();
        int y = event.getBlockSnapshot().getPos().func_177956_o();
        int z = event.getBlockSnapshot().getPos().func_177952_p();
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalCoordinate gc = entry.getKey();
            BlockPos c = gc.getCoordinate();
            if (!((float)Math.abs(c.func_177958_n() - x) < radius) || !((float)Math.abs(c.func_177956_o() - y) < radius) || !((float)Math.abs(c.func_177952_p() - z) < radius)) continue;
            Logging.logDebug((String)("Add blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
            radiationTree.addBlocker(x, y, z, blocker);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        DRMessages.INSTANCE.sendTo((IMessage)new PacketFinalizeLogin(), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        PacketHandler.onDisconnect();
    }

    @SubscribeEvent
    public void onPostWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K) {
            for (ResonatingCrystalTileEntity crystal : ResonatingCrystalTileEntity.todoCrystals) {
                crystal.realUpdate();
            }
            ResonatingCrystalTileEntity.todoCrystals.clear();
            for (AbstractSensorTileEntity sensor : AbstractSensorTileEntity.todoSensors) {
                sensor.realUpdate();
            }
            AbstractSensorTileEntity.todoSensors.clear();
        }
    }
}

