/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.generation.BOPGenLayer;
import com.google.common.base.Optional;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerBiomeEdgeBOP
extends BOPGenLayer {
    public GenLayerBiomeEdgeBOP(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] parentVals = this.field_75909_a.func_75904_a(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] out = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int y = 0; y < areaHeight; ++y) {
            for (int x = 0; x < areaWidth; ++x) {
                int southBiomeId;
                int westBiomeId;
                int eastBiomeId;
                int northBiomeId;
                this.func_75903_a(x + areaX, y + areaY);
                int biomeId = parentVals[x + 1 + (y + 1) * (areaWidth + 2)];
                if (this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BOPBiomes.mountain, BOPBiomes.mountain_foothills) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BOPBiomes.alps, BOPBiomes.alps_foothills) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, BOPBiomes.wasteland, (Optional<Biome>)Optional.of((Object)Biomes.field_76769_d)) || this.replaceBiomeEdgeIfNecessary(parentVals, out, x, y, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_76770_e), Biome.func_185362_a((Biome)Biomes.field_76783_v)) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_150607_aa), Biome.func_185362_a((Biome)Biomes.field_150589_Z)) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_150608_ab), Biome.func_185362_a((Biome)Biomes.field_150589_Z)) || this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_150578_U), Biome.func_185362_a((Biome)Biomes.field_76768_g))) continue;
                if (biomeId == Biome.func_185362_a((Biome)Biomes.field_76769_d)) {
                    northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
                    eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
                    westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
                    southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
                    if (northBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n) && eastBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n) && westBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n) && southBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n)) {
                        out[x + y * areaWidth] = biomeId;
                        continue;
                    }
                    out[x + y * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_150580_W);
                    continue;
                }
                if (biomeId == Biome.func_185362_a((Biome)Biomes.field_76780_h)) {
                    northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
                    eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
                    westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
                    southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
                    if (northBiomeId != Biome.func_185362_a((Biome)Biomes.field_76769_d) && eastBiomeId != Biome.func_185362_a((Biome)Biomes.field_76769_d) && westBiomeId != Biome.func_185362_a((Biome)Biomes.field_76769_d) && southBiomeId != Biome.func_185362_a((Biome)Biomes.field_76769_d) && northBiomeId != Biome.func_185362_a((Biome)Biomes.field_150584_S) && eastBiomeId != Biome.func_185362_a((Biome)Biomes.field_150584_S) && westBiomeId != Biome.func_185362_a((Biome)Biomes.field_150584_S) && southBiomeId != Biome.func_185362_a((Biome)Biomes.field_150584_S) && northBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n) && eastBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n) && westBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n) && southBiomeId != Biome.func_185362_a((Biome)Biomes.field_76774_n)) {
                        if (northBiomeId != Biome.func_185362_a((Biome)Biomes.field_76782_w) && southBiomeId != Biome.func_185362_a((Biome)Biomes.field_76782_w) && eastBiomeId != Biome.func_185362_a((Biome)Biomes.field_76782_w) && westBiomeId != Biome.func_185362_a((Biome)Biomes.field_76782_w)) {
                            out[x + y * areaWidth] = biomeId;
                            continue;
                        }
                        out[x + y * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_150574_L);
                        continue;
                    }
                    out[x + y * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_76772_c);
                    continue;
                }
                out[x + y * areaWidth] = biomeId;
            }
        }
        return out;
    }

    private boolean replaceBiomeEdgeIfNecessary(int[] parentVals, int[] out, int x, int y, int areaWidth, int biomeId, int fromBiomeId, int toBiomeId) {
        if (!GenLayerBiomeEdgeBOP.func_151616_a((int)biomeId, (int)fromBiomeId)) {
            return false;
        }
        int northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
        int eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
        int westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
        int southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
        out[x + y * areaWidth] = this.canBiomesBeNeighbors(northBiomeId, fromBiomeId) && this.canBiomesBeNeighbors(eastBiomeId, fromBiomeId) && this.canBiomesBeNeighbors(westBiomeId, fromBiomeId) && this.canBiomesBeNeighbors(southBiomeId, fromBiomeId) ? biomeId : toBiomeId;
        return true;
    }

    private boolean replaceBiomeEdge(int[] parentVals, int[] out, int x, int y, int areaWidth, int biomeId, Optional<Biome> fromBiome, Optional<Biome> toBiome) {
        return fromBiome.isPresent() && toBiome.isPresent() && this.replaceBiomeEdge(parentVals, out, x, y, areaWidth, biomeId, Biome.func_185362_a((Biome)((Biome)fromBiome.get())), Biome.func_185362_a((Biome)((Biome)toBiome.get())));
    }

    private boolean replaceBiomeEdge(int[] parentVals, int[] out, int x, int y, int areaWidth, int biomeId, int fromBiomeId, int toBiomeId) {
        if (biomeId != fromBiomeId) {
            return false;
        }
        int northBiomeId = parentVals[x + 1 + (y + 1 - 1) * (areaWidth + 2)];
        int eastBiomeId = parentVals[x + 1 + 1 + (y + 1) * (areaWidth + 2)];
        int westBiomeId = parentVals[x + 1 - 1 + (y + 1) * (areaWidth + 2)];
        int southBiomeId = parentVals[x + 1 + (y + 1 + 1) * (areaWidth + 2)];
        out[x + y * areaWidth] = GenLayerBiomeEdgeBOP.func_151616_a((int)northBiomeId, (int)fromBiomeId) && GenLayerBiomeEdgeBOP.func_151616_a((int)eastBiomeId, (int)fromBiomeId) && GenLayerBiomeEdgeBOP.func_151616_a((int)westBiomeId, (int)fromBiomeId) && GenLayerBiomeEdgeBOP.func_151616_a((int)southBiomeId, (int)fromBiomeId) ? biomeId : toBiomeId;
        return true;
    }

    private boolean canBiomesBeNeighbors(int biomeA, int biomeB) {
        if (GenLayerBiomeEdgeBOP.func_151616_a((int)biomeA, (int)biomeB)) {
            return true;
        }
        Biome BiomeA = Biome.func_150568_d((int)biomeA);
        Biome BiomeB = Biome.func_150568_d((int)biomeB);
        if (BiomeA != null && BiomeB != null) {
            Biome.TempCategory tempcategory1;
            Biome.TempCategory tempcategory = BiomeA.func_150561_m();
            return tempcategory == (tempcategory1 = BiomeB.func_150561_m()) || tempcategory == Biome.TempCategory.MEDIUM || tempcategory1 == Biome.TempCategory.MEDIUM;
        }
        return false;
    }
}

