/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.item;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.inventory.InventoryFlowerBasket;
import biomesoplenty.common.util.NBTUtil;
import biomesoplenty.core.BiomesOPlenty;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlowerBasket
extends Item {
    public ItemFlowerBasket() {
        this.func_185043_a(new ResourceLocation("open"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, World world, EntityLivingBase entity) {
                InventoryFlowerBasket inventory = new InventoryFlowerBasket(stack, null);
                boolean filled = false;
                for (int index = 0; index < inventory.func_70302_i_(); ++index) {
                    if (inventory.func_70301_a(index).func_190926_b()) continue;
                    filled = true;
                    break;
                }
                return filled ? 1.0f : 0.0f;
            }
        });
        this.field_77777_bU = 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTTagCompound compound = NBTUtil.getOrCreateStackNBT(stack);
            ItemFlowerBasket.clearOpenBaskets(player);
            compound.func_74757_a("BasketOpen", true);
            player.openGui((Object)BiomesOPlenty.instance, 0, world, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public static ItemStack findBasketStack(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFlowerBasket)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack findOpenBasketStack(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!ItemFlowerBasket.isBasketOpen(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isBasketOpen(@Nonnull ItemStack stack) {
        NBTTagCompound compound;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFlowerBasket && stack.func_77942_o() && (compound = stack.func_77978_p()) != null && compound.func_74764_b("BasketOpen")) {
            return compound.func_74767_n("BasketOpen");
        }
        return false;
    }

    public static void clearOpenBaskets(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            ItemFlowerBasket.closeIfBasket(stack);
        }
    }

    public static void closeIfBasket(@Nonnull ItemStack stack) {
        NBTTagCompound compound;
        if (ItemFlowerBasket.isBasketOpen(stack) && (compound = stack.func_77978_p()) != null) {
            compound.func_74757_a("BasketOpen", false);
        }
    }

    public static boolean isStackSuitableForBasket(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        return !(item instanceof ItemFlowerBasket) && (block instanceof IPlantable || block instanceof IGrowable || block instanceof IShearable || block instanceof BlockBOPMushroom || item instanceof ItemSeedFood || item instanceof ItemSeeds || item == Items.field_151120_aE || item == Items.field_151034_e || item == Items.field_151127_ba || item == Items.field_185164_cV || item == Items.field_151015_O || item == Items.field_185161_cS || item == BOPItems.berries || item == BOPItems.pear || item == BOPItems.peach || item == BOPItems.persimmon);
    }
}

