/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWaterside;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import java.util.Random;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenSteppe
extends BOPOverworldBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenSteppe() {
        super("steppe", new BOPBiome.PropsBuilder("Steppe").withGuiColour(13413215).withTemperature(Float.valueOf(0.75f)).withRainfall(Float.valueOf(0.1f)));
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SANDY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SANDY));
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = BOPBlocks.dried_sand.func_176223_P();
        this.terrainSettings.avgHeight(70.0).heightVariation(6.0, 20.0).octaves(0.0, 1.0, 2.0, 2.0, 1.0, 0.0).sidewaysNoise(0.1);
        this.canSpawnInBiome = false;
        this.canGenerateVillages = true;
        this.addWeight(BOPClimates.DRY_TEMPERATE, 5);
        if (BOPBiomes.gravel_beach.isPresent()) {
            this.beachBiomeLocation = ((BOPOverworldBiome)BOPBiomes.gravel_beach.get()).getResourceLocation();
        }
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityHorse.class, 5, 2, 6));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDonkey.class, 1, 1, 1));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityLlama.class, 5, 4, 6));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        this.addGenerator("sand", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(3.0f)).maxRadius(7).with(Blocks.field_150354_m.func_176223_P())).create());
        this.addGenerator("dead_bushes", GeneratorStage.DEAD_BUSH, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(Blocks.field_150330_I.func_176223_P())).generationAttempts(4)).create());
        this.addGenerator("desertgrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(12.0f)).with(BOPPlants.DESERTGRASS)).generationAttempts(8)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(1.9f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 7, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 3, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("ruby", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.RUBY)).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 1.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }

    public int func_180627_b(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeGrassColor(noise < -0.1 ? 13741418 : 13018487);
    }

    public int func_180625_c(BlockPos pos) {
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeFoliageColor(noise < -0.1 ? 13741418 : 13018487);
    }
}

