/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.portal.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.portalgun.common.portal.PortalGunHelper;
import me.ichun.mods.portalgun.common.portal.info.ChannelIndicator;
import me.ichun.mods.portalgun.common.portal.info.ChannelInfo;
import me.ichun.mods.portalgun.common.portal.info.PortalInfo;
import me.ichun.mods.portalgun.common.portal.world.PortalPlacement;
import me.ichun.mods.portalgun.common.tileentity.TilePortalMaster;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class PortalsInWorldSavedData
extends WorldSavedData {
    public static final String DATA_ID = "PortalGunPortalData";
    public HashSet<PortalInfo> portalList = new HashSet();
    public HashMap<String, ArrayList<ChannelInfo>> channelList = new HashMap();
    public boolean initialized;

    public PortalsInWorldSavedData() {
        super(DATA_ID);
    }

    public PortalsInWorldSavedData(String ignored) {
        this();
    }

    public void initialize(World world) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap<String, PortalInfo> channelPortalMap = new HashMap<String, PortalInfo>();
        Iterator<PortalInfo> ite = this.portalList.iterator();
        while (ite.hasNext()) {
            PortalInfo info = ite.next();
            TilePortalMaster pm = info.getTileEntity(world);
            if (pm == null) {
                ite.remove();
                continue;
            }
            PortalPlacement placement = pm.getPortalPlacementFromInfo(info);
            if (placement == null || placement.destroyed) {
                pm.removePortal(placement);
                ite.remove();
                continue;
            }
            placement.setPortal(info);
            String type = info.uuid + "_" + info.channelName + "_" + (info.isTypeA ? "A" : "B");
            if (channelPortalMap.containsKey(type)) {
                pm.removePortal(placement);
                ite.remove();
                continue;
            }
            channelPortalMap.put(type, info);
        }
        ite = this.portalList.iterator();
        while (ite.hasNext()) {
            PortalPlacement p1;
            PortalInfo portal = ite.next();
            String opposite = portal.uuid + "_" + portal.channelName + "_" + (!portal.isTypeA ? "A" : "B");
            PortalInfo pair = (PortalInfo)channelPortalMap.get(opposite);
            if (portal.getPair() != null && pair == null) {
                p1 = portal.getPortalPlacement(world);
                if (p1 != null) {
                    p1.remove(BlockPos.field_177992_a);
                }
                ite.remove();
                continue;
            }
            if (pair == null) continue;
            p1 = portal.getPortalPlacement(world);
            PortalPlacement p2 = pair.getPortalPlacement(world);
            if (p1 != null && p2 != null) {
                if (p1.getWidth() != p2.getWidth() || p1.getHeight() != p2.getHeight()) {
                    p1.remove(BlockPos.field_177992_a);
                    p2.remove(BlockPos.field_177992_a);
                    continue;
                }
                p1.setPortalPair(pair);
                p2.setPortalPair(portal);
                continue;
            }
            ite.remove();
        }
    }

    public PortalInfo findPair(PortalInfo info) {
        for (PortalInfo info1 : this.portalList) {
            if (!info1.isPair(info)) continue;
            return info1;
        }
        return null;
    }

    public void removePortal(World world, PortalInfo info) {
        for (PortalInfo info1 : this.portalList) {
            if (!info1.isSameType(info)) continue;
            PortalPlacement portal = info1.getPortalPlacement(world);
            if (portal != null) {
                portal.remove(BlockPos.field_177992_a);
            }
            return;
        }
    }

    public void updatePortalInfo(World world, PortalInfo info, boolean removal) {
        if (removal) {
            if (info.getPair() != null) {
                BlockPos pos = info.getPair().getPos();
                PortalPlacement pp = info.getPair().getPortalPlacement(world);
                if (pp != null) {
                    pp.setPortalPair(null);
                }
                IBlockState state = world.func_180495_p(pos);
                world.func_184138_a(pos, state, state, 3);
            }
            this.portalList.remove(info);
        } else {
            PortalPlacement portal;
            PortalInfo pair = null;
            PortalInfo identicalType = null;
            for (PortalInfo info1 : this.portalList) {
                if (info1.isSameType(info) && info1 != info) {
                    identicalType = info1;
                } else if (info1.isPair(info)) {
                    pair = info1;
                }
                if (identicalType == null || pair == null) continue;
                break;
            }
            if (identicalType != null && (portal = identicalType.getPortalPlacement(world)) != null) {
                portal.remove(BlockPos.field_177992_a);
            }
            if (pair != null) {
                PortalPlacement p1 = info.getPortalPlacement(world);
                PortalPlacement p2 = pair.getPortalPlacement(world);
                boolean doPair = false;
                if (p1 != null && p2 != null) {
                    doPair = true;
                    if (p1.getWidth() != p2.getWidth() || p1.getHeight() != p2.getHeight()) {
                        p2.remove(BlockPos.field_177992_a);
                        doPair = PortalGunHelper.spawnPortal(world, pair.getPos().func_177967_a(p2.getFaceOn(), -1), p2.getFaceOn(), p2.getUpDir(), pair, (int)p1.getWidth(), (int)p1.getHeight(), false);
                    }
                }
                if (doPair) {
                    p1.setPortalPair(pair);
                    p2.setPortalPair(info);
                    if (pair.getPos().func_177956_o() >= 0) {
                        IBlockState state = world.func_180495_p(pair.getPos());
                        world.func_184138_a(pair.getPos(), state, state, 3);
                    }
                }
            }
            if (!this.portalList.contains(info)) {
                this.portalList.add(info);
            }
        }
        this.func_76185_a();
    }

    public void addChannel(String uuid, ChannelInfo info) {
        ArrayList<ChannelInfo> channels = this.channelList.get(uuid);
        if (channels == null) {
            channels = new ArrayList();
            this.channelList.put(uuid, channels);
        }
        if (!channels.contains(info)) {
            channels.add(info);
        }
    }

    public ChannelInfo getChannel(String uuid, String channelName) {
        ArrayList channels = this.channelList.computeIfAbsent(uuid, k -> new ArrayList());
        ChannelInfo chan = null;
        for (ChannelInfo channel : channels) {
            if (!channel.channelName.equals(channelName)) continue;
            chan = channel;
            break;
        }
        if (chan == null) {
            int[] colours = PortalGunHelper.generateChannelColour(uuid, channelName);
            chan = new ChannelInfo(uuid, channelName).setColour(colours[0], colours[1]);
            this.func_76185_a();
        }
        return chan;
    }

    public ChannelIndicator getChannelIndicator(String username, String channelName, int dimension, ChannelInfo channelInfo) {
        ChannelIndicator indicator = new ChannelIndicator(channelInfo, dimension);
        for (PortalInfo portal : this.portalList) {
            if (!portal.uuid.equals(username) || !portal.channelName.equals(channelName)) continue;
            if (portal.isTypeA) {
                indicator.setPortalAStatus(true);
            } else {
                indicator.setPortalBStatus(true);
            }
            if (!indicator.portalAAvailable || !indicator.portalBAvailable) continue;
            break;
        }
        return indicator;
    }

    public void func_76184_a(NBTTagCompound tag) {
        int size = tag.func_74762_e("portalCount");
        for (int i = 0; i < size; ++i) {
            this.portalList.add(new PortalInfo().readFromNBT(tag.func_74775_l("info_" + i)));
        }
        int channelCount = tag.func_74762_e("channelCount");
        for (int i = 0; i < channelCount; ++i) {
            ChannelInfo info = new ChannelInfo("Unknown", "Unknown");
            info.readFromNBT(tag.func_74775_l("channel_" + i));
            if (info.uuid.equals("Unknown")) continue;
            this.addChannel(info.uuid, info);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        tag.func_74768_a("portalCount", this.portalList.size());
        int i = 0;
        for (PortalInfo info : this.portalList) {
            tag.func_74782_a("info_" + i, (NBTBase)info.writeToNBT(new NBTTagCompound()));
            ++i;
        }
        int channelCount = 0;
        for (Map.Entry<String, ArrayList<ChannelInfo>> e : this.channelList.entrySet()) {
            ArrayList<ChannelInfo> channels = e.getValue();
            for (ChannelInfo channel : channels) {
                tag.func_74782_a("channel_" + channelCount, (NBTBase)channel.writeToNBT(new NBTTagCompound()));
                ++channelCount;
            }
        }
        tag.func_74768_a("channelCount", channelCount);
        return tag;
    }
}

