/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util;

import aroma1997.core.Aroma1997Core;
import aroma1997.core.log.LogHelper;
import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.ShapedAromicRecipe;
import aroma1997.core.recipes.ShapelessAromicRecipe;
import aroma1997.core.util.Util;
import aroma1997.core.util.registry.AromaAutoRegistry;
import aroma1997.core.util.registry.DelayedRegistration;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AromaRegistry {
    private static int recipeID = 0;
    private static final DelayedRegistration reg = new DelayedRegistration();

    @Deprecated
    public static void register(Object o) {
        AromaRegistry.register(o.getClass(), o);
    }

    @Deprecated
    public static void register(Class<?> clazz) {
        AromaRegistry.register(clazz, null);
    }

    @Deprecated
    public static <T> void register(Class<?> clazz, Object o) {
        AromaAutoRegistry.INSTANCE.registerClassWrapper(clazz, o);
    }

    public static <T extends IForgeRegistryEntry<T>, C extends T> C registerObjectLater(Class<T> clazz, C object, ResourceLocation rl) {
        object.setRegistryName(rl);
        return AromaRegistry.registerObjectLater(clazz, object);
    }

    public static <T extends IForgeRegistryEntry<T>, C extends T> C registerObjectLater(Class<T> clazz, C object) {
        reg.addToRegister(clazz, object);
        return object;
    }

    public static DelayedRegistration getDelayedRegistration() {
        return reg;
    }

    public static <T extends IForgeRegistryEntry<T>, C extends T> C registerObjectForced(Class<T> clazz, C object, ResourceLocation loc) {
        object.setRegistryName(loc);
        return AromaRegistry.registerObjectForced(clazz, object);
    }

    public static <T extends IForgeRegistryEntry<T>, C extends T> C registerObjectForced(Class<T> clazz, C object) {
        GameRegistry.findRegistry(clazz).register(object);
        return object;
    }

    public static IAromicRecipe registerShapedRecipe(ResourceLocation rl, ItemStack output, Object ... params) {
        ShapedAromicRecipe recipe = new ShapedAromicRecipe(output, params);
        AromaRegistry.registerRecipe(rl, recipe);
        return recipe;
    }

    public static IAromicRecipe registerShapelessRecipe(ResourceLocation rl, ItemStack output, Object ... params) {
        ShapelessAromicRecipe recipe = new ShapelessAromicRecipe(output, params);
        AromaRegistry.registerRecipe(rl, recipe);
        return recipe;
    }

    @Deprecated
    public static IAromicRecipe registerShapedRecipe(ItemStack output, Object ... params) {
        ShapedAromicRecipe recipe = new ShapedAromicRecipe(output, params);
        AromaRegistry.registerRecipe(recipe);
        return recipe;
    }

    @Deprecated
    public static IAromicRecipe registerShapelessRecipe(ItemStack output, Object ... params) {
        ShapelessAromicRecipe recipe = new ShapelessAromicRecipe(output, params);
        AromaRegistry.registerRecipe(recipe);
        return recipe;
    }

    private static void registerRecipe(IRecipe recipe) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null) {
            LogHelper.getLogger().warn("Failed to register recipe. Cannot determine parent mod.");
            return;
        }
        ResourceLocation rl = new ResourceLocation(Util.getCurrentModName(), "" + recipeID++);
        AromaRegistry.registerRecipe(rl, recipe);
    }

    public static void registerRecipe(ResourceLocation loc, IRecipe recipe) {
        recipe.setRegistryName(loc);
        AromaRegistry.registerObjectForced(IRecipe.class, recipe);
    }

    public static void registerForMeshing(ItemStack stack, ModelResourceLocation rl) {
        Aroma1997Core.proxy.registerForMeshing(stack, rl);
    }

    static {
        AromaAutoRegistry.INSTANCE.registerInfo(reg);
    }
}

