/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.block.te.element;

import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.block.te.element.TileEntityElementBase;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class FakePlayerElement
extends TileEntityElementBase {
    private EntityPlayerMP fakePlayer;
    private UUID uuid = UUID.randomUUID();

    public FakePlayerElement(TileEntityBase parent) {
        super(parent);
    }

    @Override
    public void load() {
        World world = this.getParent().func_145831_w();
        if (!world.field_72995_K) {
            this.fakePlayer = this.getFakePlayer((WorldServer)this.getParent().func_145831_w(), new GameProfile(this.uuid, this.uuid.toString()));
            this.initialize(this.fakePlayer);
        }
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        String uuid = nbt.func_74779_i("uuid");
        this.uuid = UUID.fromString(uuid);
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound nbt) {
        nbt.func_74778_a("uuid", this.uuid + "");
        return nbt;
    }

    @Override
    public void unload() {
        this.fakePlayer = null;
    }

    public EntityPlayerMP getFakePlayer() {
        if (this.fakePlayer != null) {
            this.reload(this.fakePlayer);
        }
        return this.fakePlayer;
    }

    protected FakePlayer getFakePlayer(WorldServer world, GameProfile profile) {
        return new RealFakePlayer(world, profile);
    }

    protected void initialize(EntityPlayerMP player) {
        this.fakePlayer.func_192039_O().func_192745_a();
        this.fakePlayer.eyeHeight = 0.5f;
        this.reload(player);
    }

    protected void reload(EntityPlayerMP player) {
        BlockPos pos = this.getParent().func_174877_v();
        this.fakePlayer.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    @Override
    public Class<? extends TileEntityElementBase> getElementClass() {
        return FakePlayerElement.class;
    }

    protected static class RealFakePlayer
    extends FakePlayer {
        public RealFakePlayer(WorldServer world, GameProfile name) {
            super(world, name);
        }

        public void func_180468_a(IInteractionObject guiOwner) {
        }

        public void func_71007_a(IInventory chestInventory) {
        }

        public void func_184824_a(TileEntityCommandBlock commandBlock) {
        }

        public void openGui(Object mod, int modGuiId, World world, int x, int y, int z) {
        }

        public Vec3d func_174791_d() {
            return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }

        public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        }
    }
}

