/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.collision;

import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTraceResult;
import com.raoulvdberge.refinedstorage.render.collision.AdvancedRayTracer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockHighlightListener {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockDrawHighlight(DrawBlockHighlightEvent e) {
        if (e.getTarget() == null || e.getTarget().func_178782_a() == null) {
            return;
        }
        EntityPlayer player = e.getPlayer();
        BlockPos pos = e.getTarget().func_178782_a();
        Block block = player.func_130014_f_().func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockCable)) {
            return;
        }
        BlockCable cable = (BlockCable)block;
        IBlockState state = cable.func_176221_a(cable.func_176223_P(), (IBlockAccess)player.func_130014_f_(), pos);
        AdvancedRayTraceResult<RayTraceResult> result = AdvancedRayTracer.rayTrace(pos, AdvancedRayTracer.getStart(player), AdvancedRayTracer.getEnd(player), cable.getCollisions(player.func_130014_f_().func_175625_s(pos), state));
        e.setCanceled(true);
        if (result == null) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)e.getPartialTicks();
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)e.getPartialTicks();
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)e.getPartialTicks();
        for (AxisAlignedBB aabb : result.getGroup().getItems()) {
            this.drawSelectionBoundingBox(aabb.func_72321_a((double)0.002f, (double)0.002f, (double)0.002f).func_72317_d(-d0, -d1, -d2).func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void drawSelectionBoundingBox(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        buffer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        buffer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }
}

