/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.GuiPriority;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonAccessType;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonCompare;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonMode;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonType;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class GuiStorage
extends GuiBase {
    private IGuiStorage gui;
    private String texture;
    private GuiButton priorityButton;
    private int barX = 8;
    private int barY = 54;
    private int barWidth = 16;
    private int barHeight = 70;

    public GuiStorage(ContainerBase container, IGuiStorage gui, String texture) {
        super(container, 176, 223);
        this.gui = gui;
        this.texture = texture;
    }

    public GuiStorage(ContainerBase container, IGuiStorage gui) {
        this(container, gui, "gui/storage.png");
    }

    @Override
    public void init(int x, int y) {
        if (this.gui.getRedstoneModeParameter() != null) {
            this.addSideButton(new SideButtonRedstoneMode(this, this.gui.getRedstoneModeParameter()));
        }
        if (this.gui.getTypeParameter() != null) {
            this.addSideButton(new SideButtonType(this, this.gui.getTypeParameter()));
        }
        if (this.gui.getFilterParameter() != null) {
            this.addSideButton(new SideButtonMode(this, this.gui.getFilterParameter()));
        }
        if (this.gui.getCompareParameter() != null) {
            this.addSideButton(new SideButtonCompare(this, this.gui.getCompareParameter(), 1));
            this.addSideButton(new SideButtonCompare(this, this.gui.getCompareParameter(), 2));
        }
        if (this.gui.getAccessTypeParameter() != null) {
            this.addSideButton(new SideButtonAccessType(this, this.gui.getAccessTypeParameter()));
        }
        int buttonWidth = 10 + this.field_146289_q.func_78256_a(GuiStorage.t("misc.refinedstorage:priority", new Object[0]));
        this.priorityButton = this.addButton(x + 169 - buttonWidth, y + 41, buttonWidth, 20, GuiStorage.t("misc.refinedstorage:priority", new Object[0]));
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture(this.texture);
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        int barHeightNew = (int)((float)this.gui.getStored() / (float)this.gui.getCapacity() * (float)this.barHeight);
        this.drawTexture(x + this.barX, y + this.barY + this.barHeight - barHeightNew, 179, this.barHeight - barHeightNew, this.barWidth, barHeightNew);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiStorage.t(this.gui.getGuiTitle(), new Object[0]));
        this.drawString(7, 42, this.gui.getCapacity() == -1 ? GuiStorage.t("misc.refinedstorage:storage.stored_minimal", API.instance().getQuantityFormatter().formatWithUnits(this.gui.getStored())) : GuiStorage.t("misc.refinedstorage:storage.stored_capacity_minimal", API.instance().getQuantityFormatter().formatWithUnits(this.gui.getStored()), API.instance().getQuantityFormatter().formatWithUnits(this.gui.getCapacity())));
        if (this.texture.contains("disk_drive")) {
            this.drawString(79, 42, GuiStorage.t("gui.refinedstorage:disk_drive.disks", new Object[0]));
        }
        this.drawString(7, 129, GuiStorage.t("container.inventory", new Object[0]));
        if (this.inBounds(this.barX, this.barY, this.barWidth, this.barHeight, mouseX, mouseY)) {
            int full = 0;
            if (this.gui.getCapacity() >= 0) {
                full = (int)((float)this.gui.getStored() / (float)this.gui.getCapacity() * 100.0f);
            }
            this.drawTooltip(mouseX, mouseY, (this.gui.getCapacity() == -1 ? GuiStorage.t("misc.refinedstorage:storage.stored_minimal", API.instance().getQuantityFormatter().format(this.gui.getStored())) : GuiStorage.t("misc.refinedstorage:storage.stored_capacity_minimal", API.instance().getQuantityFormatter().format(this.gui.getStored()), API.instance().getQuantityFormatter().format(this.gui.getCapacity()))) + "\n" + TextFormatting.GRAY + GuiStorage.t("misc.refinedstorage:storage.full", full));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.priorityButton) {
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiPriority(this, this.gui.getPriorityParameter()));
        }
    }
}

