/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.block.info.IBlockInfo;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockBase;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBase
extends Block {
    protected final IBlockInfo info;

    public BlockBase(IBlockInfo info) {
        super(info.getMaterial());
        this.info = info;
        this.func_149711_c(info.getHardness());
        this.setRegistryName(info.getId());
        this.func_149647_a(RS.INSTANCE.tab);
        this.func_149672_a(info.getSoundType());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
    }

    public String func_149739_a() {
        return "block." + this.info.getId().toString();
    }

    protected BlockStateContainer.Builder createBlockStateBuilder() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        if (this.getDirection() != null) {
            builder.add(new IProperty[]{this.getDirection().getProperty()});
        }
        return builder;
    }

    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().build();
    }

    public Item createItem() {
        return new ItemBlockBase(this, false);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        if (this.getDirection() != null && (tile = world.func_175625_s(pos)) instanceof TileBase) {
            return state.func_177226_a((IProperty)this.getDirection().getProperty(), (Comparable)((TileBase)tile).getDirection());
        }
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (!world.field_72995_K && this.getDirection() != null) {
            TileBase tile = (TileBase)world.func_175625_s(pos);
            EnumFacing newDirection = this.getDirection().cycle(tile.getDirection());
            tile.setDirection(newDirection);
            WorldUtils.updateBlock(world, pos);
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropContents(world, pos);
        this.removeTile(world, pos, state);
    }

    void removeTile(World world, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    void dropContents(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase && ((TileBase)tile).getDrops() != null) {
            WorldUtils.dropInventory(world, pos, ((TileBase)tile).getDrops());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public final boolean hasTileEntity(IBlockState state) {
        return this.info.hasTileEntity();
    }

    public final TileEntity createTileEntity(World world, IBlockState state) {
        return this.info.createTileEntity();
    }

    @Nullable
    public BlockDirection getDirection() {
        return null;
    }

    public final IBlockInfo getInfo() {
        return this.info;
    }
}

