/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator.StorageDiskFluidManipulatorWrapper;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator.StorageDiskItemManipulatorWrapper;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerProxy;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDiskManipulator;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeDiskManipulator
extends NetworkNode
implements IComparable,
IFilterable,
IType,
IStorageDiskContainerContext {
    public static final String ID = "disk_manipulator";
    public static final int IO_MODE_INSERT = 0;
    public static final int IO_MODE_EXTRACT = 1;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_IO_MODE = "IOMode";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private int compare = 3;
    private int mode = 1;
    private int type = 0;
    private int ioMode = 0;
    private IStorageDisk<ItemStack>[] itemDisks = new IStorageDisk[6];
    private IStorageDisk<FluidStack>[] fluidDisks = new IStorageDisk[6];
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, new ListenerNetworkNode(this), new int[]{2, 4}){

        @Override
        public int getItemInteractCount() {
            int count = super.getItemInteractCount();
            if (NetworkNodeDiskManipulator.this.type == 1) {
                count *= 1000;
            }
            return count;
        }
    };
    private ItemHandlerBase inputDisks = new ItemHandlerBase(3, new ListenerNetworkNode(this), new Predicate[]{NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                StackUtils.createStorages(NetworkNodeDiskManipulator.this.world, this.getStackInSlot(slot), slot, NetworkNodeDiskManipulator.this.itemDisks, NetworkNodeDiskManipulator.this.fluidDisks, s -> new StorageDiskItemManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<ItemStack>)s), s -> new StorageDiskFluidManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<FluidStack>)s));
                WorldUtils.updateBlock(NetworkNodeDiskManipulator.this.world, NetworkNodeDiskManipulator.this.pos);
            }
        }
    };
    private ItemHandlerBase outputDisks = new ItemHandlerBase(3, new ListenerNetworkNode(this), new Predicate[]{NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                StackUtils.createStorages(NetworkNodeDiskManipulator.this.world, this.getStackInSlot(slot), 3 + slot, NetworkNodeDiskManipulator.this.itemDisks, NetworkNodeDiskManipulator.this.fluidDisks, s -> new StorageDiskItemManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<ItemStack>)s), s -> new StorageDiskFluidManipulatorWrapper(NetworkNodeDiskManipulator.this, (IStorageDisk<FluidStack>)s));
                WorldUtils.updateBlock(NetworkNodeDiskManipulator.this.world, NetworkNodeDiskManipulator.this.pos);
            }
        }
    };
    private ItemHandlerProxy disks = new ItemHandlerProxy((IItemHandler)this.inputDisks, (IItemHandler)this.outputDisks);
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private FluidInventory fluidFilters = new FluidInventory(9, new ListenerNetworkNode(this));

    public NetworkNodeDiskManipulator(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.diskManipulatorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void update() {
        int slot;
        super.update();
        if (this.network == null || !this.canUpdate() || this.ticks % this.upgrades.getSpeed() != 0) {
            return;
        }
        if (this.type == 0) {
            for (slot = 0; slot < 3 && (this.itemDisks[slot] == null || this.isItemDiskDone(this.itemDisks[slot], slot)); ++slot) {
            }
            if (slot == 3) {
                return;
            }
            IStorageDisk<ItemStack> storage = this.itemDisks[slot];
            if (this.ioMode == 0) {
                this.insertItemIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractItemFromNetwork(storage, slot);
            }
        } else if (this.type == 1) {
            while (slot < 3 && (this.fluidDisks[slot] == null || this.isFluidDiskDone(this.fluidDisks[slot], slot))) {
                ++slot;
            }
            if (slot == 3) {
                return;
            }
            IStorageDisk<FluidStack> storage = this.fluidDisks[slot];
            if (this.ioMode == 0) {
                this.insertFluidIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFluidFromNetwork(storage, slot);
            }
        }
    }

    private void insertItemIntoNetwork(IStorageDisk<ItemStack> storage, int slot) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            ItemStack extracted = storage.extract(stack, this.upgrades.getItemInteractCount(), this.compare, Action.PERFORM);
            if (extracted == null) continue;
            ItemStack remainder = this.network.insertItem(extracted, extracted.func_190916_E(), Action.PERFORM);
            if (remainder == null) break;
            storage.insert(extracted == remainder ? remainder.func_77946_l() : remainder, remainder.func_190916_E(), Action.PERFORM);
        }
    }

    private boolean isItemDiskDone(IStorageDisk<ItemStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack remainder;
            ItemStack stack = (ItemStack)stacks.get(i);
            ItemStack extracted = storage.extract(stack, this.upgrades.getItemInteractCount(), this.compare, Action.SIMULATE);
            if (extracted == null || (remainder = this.network.insertItem(extracted, extracted.func_190916_E(), Action.SIMULATE)) != null) continue;
            return false;
        }
        return true;
    }

    private void extractItemFromNetwork(IStorageDisk<ItemStack> storage, int slot) {
        ItemStack extracted = null;
        int i = 0;
        if (this.itemFilters.isEmpty()) {
            ItemStack toExtract = null;
            ArrayList<ItemStack> networkItems = new ArrayList<ItemStack>(this.network.getItemStorageCache().getList().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.func_190926_b()) && j < networkItems.size()) {
                toExtract = networkItems.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractItem(toExtract, this.upgrades.getItemInteractCount(), this.compare, Action.PERFORM);
            }
        } else {
            while (this.itemFilters.getSlots() > i && extracted == null) {
                ItemStack filterStack = ItemStack.field_190927_a;
                while (this.itemFilters.getSlots() > i && filterStack.func_190926_b()) {
                    filterStack = this.itemFilters.getStackInSlot(i++);
                }
                if (filterStack.func_190926_b()) continue;
                extracted = this.network.extractItem(filterStack, this.upgrades.getItemInteractCount(), this.compare, Action.PERFORM);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack remainder = storage.insert(extracted, extracted.func_190916_E(), Action.PERFORM);
        if (remainder != null) {
            this.network.insertItem(remainder, remainder.func_190916_E(), Action.PERFORM);
        }
    }

    private void insertFluidIntoNetwork(IStorageDisk<FluidStack> storage, int slot) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        FluidStack extracted = null;
        int i = 0;
        while (extracted == null && stacks.size() > i) {
            FluidStack stack = (FluidStack)stacks.get(i++);
            extracted = storage.extract(stack, this.upgrades.getItemInteractCount(), this.compare, Action.PERFORM);
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = this.network.insertFluid(extracted, extracted.amount, Action.PERFORM);
        if (remainder != null) {
            storage.insert(remainder, remainder.amount, Action.PERFORM);
        }
    }

    private boolean isFluidDiskDone(IStorageDisk<FluidStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            FluidStack remainder;
            FluidStack stack = (FluidStack)stacks.get(i);
            FluidStack extracted = storage.extract(stack, this.upgrades.getItemInteractCount(), this.compare, Action.SIMULATE);
            if (extracted == null || (remainder = this.network.insertFluid(extracted, extracted.amount, Action.SIMULATE)) != null) continue;
            return false;
        }
        return true;
    }

    private void extractFluidFromNetwork(IStorageDisk<FluidStack> storage, int slot) {
        FluidStack extracted = null;
        int i = 0;
        if (this.fluidFilters.isEmpty()) {
            FluidStack toExtract = null;
            ArrayList<FluidStack> networkFluids = new ArrayList<FluidStack>(this.network.getFluidStorageCache().getList().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.amount == 0) && j < networkFluids.size()) {
                toExtract = networkFluids.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractFluid(toExtract, this.upgrades.getItemInteractCount(), this.compare, Action.PERFORM);
            }
        } else {
            while (this.fluidFilters.getSlots() > i && extracted == null) {
                FluidStack filterStack = null;
                while (this.fluidFilters.getSlots() > i && filterStack == null) {
                    filterStack = this.fluidFilters.getFluid(i++);
                }
                if (filterStack == null) continue;
                extracted = this.network.extractFluid(filterStack, this.upgrades.getItemInteractCount(), this.compare, Action.PERFORM);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = storage.insert(extracted, extracted.amount, Action.PERFORM);
        if (remainder != null) {
            this.network.insertFluid(remainder, remainder.amount, Action.PERFORM);
        }
    }

    private void moveDriveToOutput(int slot) {
        ItemStack disk = this.inputDisks.getStackInSlot(slot);
        if (!disk.func_190926_b()) {
            int i;
            for (i = 0; i < 3 && !this.outputDisks.getStackInSlot(i).func_190926_b(); ++i) {
            }
            if (i == 3) {
                return;
            }
            this.inputDisks.extractItem(slot, 1, false);
            this.outputDisks.insertItem(i, disk, false);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileDiskManipulator.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    public int getIoMode() {
        return this.ioMode;
    }

    public void setIoMode(int ioMode) {
        this.ioMode = ioMode;
    }

    public IItemHandler getInputDisks() {
        return this.inputDisks;
    }

    public IItemHandler getOutputDisks() {
        return this.outputDisks;
    }

    public ItemHandlerProxy getDisks() {
        return this.disks;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IStorageDisk[] getItemDisks() {
        return this.itemDisks;
    }

    public IStorageDisk[] getFluidDisks() {
        return this.fluidDisks;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 3, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.inputDisks, 4, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.outputDisks, 5, tag);
        if (API.instance().getOneSixMigrationHelper().migrateDiskInventory(this.world, (IItemHandlerModifiable)this.inputDisks)) {
            this.markDirty();
        }
        if (API.instance().getOneSixMigrationHelper().migrateDiskInventory(this.world, (IItemHandlerModifiable)this.outputDisks)) {
            this.markDirty();
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        StackUtils.writeItems((IItemHandler)this.inputDisks, 4, tag);
        StackUtils.writeItems((IItemHandler)this.outputDisks, 5, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 1, tag);
        tag.func_74782_a(NBT_FLUID_FILTERS, (NBTBase)this.fluidFilters.writeToNbt());
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74768_a(NBT_IO_MODE, this.ioMode);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 1, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_IO_MODE)) {
            this.ioMode = tag.func_74762_e(NBT_IO_MODE);
        }
        OneSixMigrationHelper.migrateEmptyWhitelistToEmptyBlacklist(this.version, this, this.itemFilters);
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDisks, this.outputDisks, this.upgrades});
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }
}

