/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.item.validator.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.item.ItemNetworkCard;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeNetworkTransmitter
extends NetworkNode {
    public static final String ID = "network_transmitter";
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(1, new ListenerNetworkNode(this), new int[]{5}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (NetworkNodeNetworkTransmitter.this.network != null) {
                NetworkNodeNetworkTransmitter.this.network.getNodeGraph().rebuild();
            }
        }
    };
    private ItemHandlerBase networkCard = new ItemHandlerBase(1, new ListenerNetworkNode(this), new Predicate[]{new ItemValidatorBasic(RSItems.NETWORK_CARD)}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemStack card = this.getStackInSlot(slot);
            if (card.func_190926_b()) {
                NetworkNodeNetworkTransmitter.this.receiver = null;
            } else {
                NetworkNodeNetworkTransmitter.this.receiver = ItemNetworkCard.getReceiver(card);
                NetworkNodeNetworkTransmitter.this.receiverDimension = ItemNetworkCard.getDimension(card);
            }
            if (NetworkNodeNetworkTransmitter.this.network != null) {
                NetworkNodeNetworkTransmitter.this.network.getNodeGraph().rebuild();
            }
        }
    };
    private BlockPos receiver;
    private int receiverDimension;

    public NetworkNodeNetworkTransmitter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.networkCard, 0, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.networkCard, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public int getEnergyUsage() {
        return Math.min(RS.INSTANCE.config.interdimensionalUpgradeUsage, RS.INSTANCE.config.networkTransmitterUsage + (this.isSameDimension() ? (int)Math.ceil(RS.INSTANCE.config.networkTransmitterPerBlockUsage * (float)this.getDistance()) : 0) + this.upgrades.getEnergyUsage());
    }

    public ItemHandlerBase getNetworkCard() {
        return this.networkCard;
    }

    public ItemHandlerUpgrade getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.networkCard, this.upgrades});
    }

    @Nullable
    public BlockPos getReceiver() {
        return this.receiver;
    }

    public int getReceiverDimension() {
        return this.receiverDimension;
    }

    public int getDistance() {
        if (this.receiver == null) {
            return 0;
        }
        return (int)Math.sqrt(Math.pow(this.pos.func_177958_n() - this.receiver.func_177958_n(), 2.0) + Math.pow(this.pos.func_177956_o() - this.receiver.func_177956_o(), 2.0) + Math.pow(this.pos.func_177952_p() - this.receiver.func_177952_p(), 2.0));
    }

    public boolean isSameDimension() {
        return this.world.field_73011_w.getDimension() == this.receiverDimension;
    }

    public boolean isDimensionSupported() {
        return this.isSameDimension() || this.upgrades.hasUpgrade(5);
    }

    private boolean canTransmit() {
        return this.canUpdate() && this.receiver != null && this.isDimensionSupported();
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public boolean shouldRebuildGraphOnChange() {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        super.visit(operator);
        if (this.canTransmit()) {
            if (!this.isSameDimension()) {
                WorldServer dimensionWorld = DimensionManager.getWorld((int)this.receiverDimension);
                if (dimensionWorld != null) {
                    operator.apply((World)dimensionWorld, this.receiver, null);
                }
            } else {
                operator.apply(this.world, this.receiver, null);
            }
        }
    }
}

