/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network;

import com.google.common.collect.Sets;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockController;
import com.raoulvdberge.refinedstorage.tile.TileController;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkNodeGraph
implements INetworkNodeGraph {
    private TileController controller;
    private Set<INetworkNode> nodes = Sets.newConcurrentHashSet();
    private Set<Consumer<INetwork>> postRebuildHandlers = new HashSet<Consumer<INetwork>>();
    private boolean rebuilding = false;

    public NetworkNodeGraph(TileController controller) {
        this.controller = controller;
    }

    @Override
    public void rebuild() {
        Visitor currentVisitor;
        this.rebuilding = true;
        Operator operator = new Operator();
        BlockPos controllerPos = this.controller.func_174877_v();
        World controllerWorld = this.controller.func_145831_w();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            INetworkNodeProxy otherNodeProxy;
            Object otherNode;
            BlockPos pos = controllerPos.func_177972_a(facing);
            TileEntity tile = controllerWorld.func_175625_s(pos);
            if (tile != null && tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d()) && (otherNode = (otherNodeProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d()))).getNode()) instanceof ICoverable && ((ICoverable)otherNode).getCoverManager().hasCover(facing.func_176734_d())) continue;
            operator.apply(controllerWorld, pos, facing.func_176734_d());
        }
        while ((currentVisitor = (Visitor)operator.toCheck.poll()) != null) {
            currentVisitor.visit(operator);
        }
        this.nodes = operator.foundNodes;
        for (INetworkNode node : operator.newNodes) {
            node.onConnected(this.controller);
        }
        for (INetworkNode node : operator.previousNodes) {
            node.onDisconnected(this.controller);
        }
        this.postRebuildHandlers.forEach(h -> h.accept(this.controller));
        this.postRebuildHandlers.clear();
        if (!operator.newNodes.isEmpty() || !operator.previousNodes.isEmpty()) {
            this.controller.getDataManager().sendParameterToWatchers(TileController.NODES);
        }
        this.rebuilding = false;
    }

    @Override
    public void addPostRebuildHandler(Consumer<INetwork> handler) {
        if (this.rebuilding) {
            this.postRebuildHandlers.add(handler);
        } else {
            handler.accept(this.controller);
        }
    }

    @Override
    public Collection<INetworkNode> all() {
        return this.nodes;
    }

    @Override
    public void disconnectAll() {
        this.nodes.forEach(n -> n.onDisconnected(this.controller));
        this.nodes.clear();
        this.controller.getDataManager().sendParameterToWatchers(TileController.NODES);
    }

    protected World getWorld() {
        return this.controller.func_145831_w();
    }

    private void removeOtherController(World world, BlockPos otherControllerPos) {
        if (!this.controller.func_174877_v().equals((Object)otherControllerPos)) {
            IBlockState state = world.func_180495_p(otherControllerPos);
            TileController otherController = (TileController)world.func_175625_s(otherControllerPos);
            ItemStack stackToSpawn = ItemBlockController.createStack(new ItemStack((Block)RSBlocks.CONTROLLER, 1, state.func_177230_c().func_176201_c(state)), otherController.getEnergy().getStored());
            world.func_175698_g(otherControllerPos);
            InventoryHelper.func_180173_a((World)world, (double)otherControllerPos.func_177958_n(), (double)otherControllerPos.func_177956_o(), (double)otherControllerPos.func_177952_p(), (ItemStack)stackToSpawn);
        }
    }

    private class Visitor
    implements INetworkNodeVisitor {
        private final INetworkNode node;
        private final World world;
        private final BlockPos pos;
        private final EnumFacing side;
        private final TileEntity tile;

        Visitor(INetworkNode node, World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            this.node = node;
            this.world = world;
            this.pos = pos;
            this.side = side;
            this.tile = tile;
        }

        @Override
        public void visit(INetworkNodeVisitor.Operator operator) {
            if (this.node instanceof INetworkNodeVisitor) {
                ((INetworkNodeVisitor)((Object)this.node)).visit(operator);
            } else {
                for (EnumFacing checkSide : EnumFacing.field_82609_l) {
                    Object nodeOnSide;
                    INetworkNodeProxy nodeOnSideProxy;
                    if (checkSide == this.side || (nodeOnSideProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(this.tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, checkSide))) == null || (nodeOnSide = nodeOnSideProxy.getNode()) != this.node) continue;
                    operator.apply(this.world, this.pos.func_177972_a(checkSide), checkSide.func_176734_d());
                }
            }
        }
    }

    private class Operator
    implements INetworkNodeVisitor.Operator {
        private Set<INetworkNode> foundNodes = Sets.newConcurrentHashSet();
        private Set<INetworkNode> newNodes = Sets.newConcurrentHashSet();
        private Set<INetworkNode> previousNodes = Sets.newConcurrentHashSet((Iterable)NetworkNodeGraph.access$500(NetworkNodeGraph.this));
        private Queue<Visitor> toCheck = new ArrayDeque<Visitor>();

        private Operator() {
        }

        @Override
        public void apply(World world, BlockPos pos, EnumFacing side) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                INetworkNodeProxy otherNodeProxy;
                Object otherNode;
                if (tile instanceof TileController) {
                    NetworkNodeGraph.this.removeOtherController(world, pos);
                } else if (tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, side) && this.foundNodes.add((INetworkNode)(otherNode = (otherNodeProxy = (INetworkNodeProxy)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast(tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, side))).getNode()))) {
                    if (!NetworkNodeGraph.this.nodes.contains(otherNode)) {
                        this.newNodes.add((INetworkNode)otherNode);
                    }
                    this.previousNodes.remove(otherNode);
                    this.toCheck.add(new Visitor((INetworkNode)otherNode, world, pos, side, tile));
                }
            }
        }
    }
}

