/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.tiles;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.GeneticCapabilities;
import forestry.api.genetics.IFilterData;
import forestry.api.genetics.IFilterLogic;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.sorting.FilterData;
import forestry.sorting.FilterLogic;
import forestry.sorting.gui.ContainerGeneticFilter;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.inventory.InventoryFilter;
import forestry.sorting.inventory.ItemHandlerFilter;
import forestry.sorting.tiles.IFilterContainer;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileGeneticFilter
extends TileForestry
implements IStreamableGui,
IFilterContainer {
    private static final int TRANSFER_DELAY = 5;
    private final FilterLogic logic;
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.getTileCache());

    public TileGeneticFilter() {
        this.logic = new FilterLogic(this, (logic1, server, player) -> this.sendToPlayers(server, player));
        this.setInternalInventory(new InventoryFilter(this));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74782_a("Logic", (NBTBase)this.logic.writeToNBT(new NBTTagCompound()));
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.logic.readFromNBT(data.func_74775_l("Logic"));
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.logic.writeGuiData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.logic.readGuiData(data);
    }

    private void sendToPlayers(WorldServer server, EntityPlayer entityPlayer) {
        for (EntityPlayer player : server.field_73010_i) {
            if (player == entityPlayer || !(player.field_71070_bA instanceof ContainerGeneticFilter) || !((ContainerGeneticFilter)entityPlayer.field_71070_bA).hasSameTile((ContainerGeneticFilter)player.field_71070_bA)) continue;
            ((ContainerGeneticFilter)player.field_71070_bA).setGuiNeedsUpdate(true);
        }
    }

    @Override
    protected void updateServerSide() {
        if (this.updateOnInterval(5)) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                ItemStack stack = this.func_70301_a(facing.func_176745_a());
                if (stack.func_190926_b()) continue;
                ItemStack transferredStack = this.transferItem(stack, facing);
                int remaining = stack.func_190916_E() - transferredStack.func_190916_E();
                if (remaining > 0) {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(remaining);
                    ItemStackUtil.dropItemStackAsEntity(stack.func_77946_l(), this.field_145850_b, this.field_174879_c.func_177958_n(), (float)this.field_174879_c.func_177956_o() + 0.5f, this.field_174879_c.func_177952_p());
                }
                this.func_70299_a(facing.func_176745_a(), ItemStack.field_190927_a);
            }
        }
    }

    public boolean isConnected(EnumFacing facing) {
        if (this.inventoryCache.getAdjacentInventory(facing) != null) {
            return true;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        return TileUtil.getInventoryFromTile(tileEntity, facing.func_176734_d()) != null;
    }

    private ItemStack transferItem(ItemStack itemStack, EnumFacing facing) {
        IItemHandler itemHandler = this.inventoryCache.getAdjacentInventory(facing);
        if (itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack transferredStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack.func_77946_l(), (boolean)true);
        if (transferredStack.func_190916_E() == itemStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        transferredStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack.func_77946_l(), (boolean)false);
        if (transferredStack.func_190926_b()) {
            return itemStack;
        }
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190920_e(itemStack.func_190916_E() - transferredStack.func_190916_E());
        return copy;
    }

    public Collection<EnumFacing> getValidDirections(ItemStack itemStack, EnumFacing from) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack);
        IIndividual individual = null;
        ISpeciesType type = null;
        if (root != null) {
            individual = root.getMember(itemStack);
            type = root.getType(itemStack);
        }
        FilterData filterData = new FilterData(root, individual, type);
        LinkedList<EnumFacing> validFacings = new LinkedList<EnumFacing>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing == from || !this.isValidFacing(facing, itemStack, filterData)) continue;
            validFacings.add(facing);
        }
        return validFacings;
    }

    private boolean isValidFacing(EnumFacing facing, ItemStack itemStack, IFilterData filterData) {
        return this.inventoryCache.getAdjacentInventory(facing) != null && this.logic.isValid(facing, itemStack, filterData);
    }

    @Override
    public IFilterLogic getLogic() {
        return this.logic;
    }

    @Override
    public IInventory getBuffer() {
        return this;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiGeneticFilter(this, player.field_71071_by);
    }

    @Override
    @Nullable
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerGeneticFilter(this, player.field_71071_by);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemHandlerFilter(this, facing));
        }
        if (capability == GeneticCapabilities.FILTER_LOGIC) {
            return (T)GeneticCapabilities.FILTER_LOGIC.cast((Object)this.logic);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == GeneticCapabilities.FILTER_LOGIC || super.hasCapability(capability, facing);
    }
}

