/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicInfernal
extends FarmLogicHomogeneous {
    public FarmLogicInfernal(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public String getUnlocalizedName() {
        return "for.farm.infernal";
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151075_bm);
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 0;
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return NonNullList.func_191196_a();
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position;
        Stack<ICrop> crops = new Stack<ICrop>();
        block0: for (int i = 0; i < extent && world.func_175667_e(position = this.translateWithOffset(pos.func_177984_a(), direction, i)); ++i) {
            if (world.func_175623_d(pos)) continue;
            IBlockState blockState = world.func_180495_p(position);
            for (IFarmable farmable : this.getFarmables()) {
                ICrop crop = farmable.getCropAt(world, position, blockState);
                if (crop == null) continue;
                crops.push(crop);
                continue block0;
            }
        }
        return crops;
    }

    @Override
    protected boolean maintainGermlings(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position;
        for (int i = 0; i < extent && world.func_175667_e(position = this.translateWithOffset(pos, direction, i)); ++i) {
            BlockPos soilPosition;
            IBlockState soilState;
            IBlockState blockState = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(blockState, world, position) || !this.isAcceptedSoil(soilState = world.func_180495_p(soilPosition = position.func_177977_b()))) continue;
            return this.trySetCrop(world, farmHousing, position, direction);
        }
        return false;
    }
}

