/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls.grab;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.BeefGuiControlBase;
import erogenousbeef.bigreactors.gui.controls.grab.IBeefGuiGrabbable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;

public abstract class BeefGuiGrabTarget
extends BeefGuiControlBase {
    protected static final int hoverColor = 0x33FFFFFF;
    protected static final int invalidHoverColor = 0x33FF9999;
    protected IBeefGuiGrabbable grabbable = null;

    protected BeefGuiGrabTarget(BeefGuiBase container, int x, int y) {
        super(container, x, y, 16, 16);
    }

    @Override
    public void drawForeground(TextureManager renderEngine, int mouseX, int mouseY) {
        if (this.grabbable != null) {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(this.grabbable.getIcon().toString());
            renderEngine.func_110577_a(TextureMap.field_110575_b);
            this.guiContainer.func_175175_a(this.relativeX, this.relativeY, sprite, this.width, this.height);
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.guiContainer.getGrabbedItem() != null && !this.isAcceptedGrab(this.guiContainer.getGrabbedItem())) {
                Gui.func_73734_a((int)this.relativeX, (int)this.relativeY, (int)(this.relativeX + this.width), (int)(this.relativeY + this.height), (int)0x33FF9999);
            } else {
                Gui.func_73734_a((int)this.relativeX, (int)this.relativeY, (int)(this.relativeX + this.width), (int)(this.relativeY + this.height), (int)0x33FFFFFF);
            }
        }
    }

    @Override
    public void drawBackground(TextureManager renderEngine, int mouseX, int mouseY) {
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int buttonIndex) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (buttonIndex == 0) {
                this.setSlotContents(this.guiContainer.getGrabbedItem());
                this.guiContainer.setGrabbedItem(null);
            } else {
                this.clearSlot();
            }
        }
    }

    private void clearSlot() {
        this.grabbable = null;
        this.onSlotCleared();
    }

    public void setSlotContents(IBeefGuiGrabbable grabbedItem) {
        if (grabbedItem == null) {
            this.clearSlot();
        } else if (this.grabbable != grabbedItem) {
            this.grabbable = grabbedItem;
            this.onSlotSet();
        }
    }

    public abstract void onSlotCleared();

    public abstract void onSlotSet();

    public abstract boolean isAcceptedGrab(IBeefGuiGrabbable var1);
}

