/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.api.registry.ReactorConversions;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import erogenousbeef.bigreactors.api.registry.TurbineCoil;
import erogenousbeef.bigreactors.common.BREventHandler;
import erogenousbeef.bigreactors.common.BigReactorsTickHandler;
import erogenousbeef.bigreactors.common.CommonProxy;
import erogenousbeef.bigreactors.common.CreativeTabBR;
import erogenousbeef.bigreactors.common.DebugCommand;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.config.Config;
import erogenousbeef.bigreactors.common.data.StandardReactants;
import erogenousbeef.bigreactors.common.multiblock.helpers.RadiationHelper;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.init.BrFluids;
import erogenousbeef.bigreactors.init.ObjectsHandler;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import it.zerono.mods.zerocore.lib.IModInitializationHandler;
import it.zerono.mods.zerocore.lib.gui.ModGuiHandler;
import it.zerono.mods.zerocore.lib.world.IWorldGenWhiteList;
import it.zerono.mods.zerocore.lib.world.WorldGenMinableOres;
import it.zerono.mods.zerocore.lib.world.WorldGenWhiteList;
import it.zerono.mods.zerocore.util.CodeHelper;
import java.util.Calendar;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="bigreactors", name="Extreme Reactors", version="1.12.2-0.4.5.49", acceptedMinecraftVersions="1.12.2", dependencies="required-after:forge@[14.23.2.2611,);required-after:zerocore@[1.12-0.1.2.2,);after:computercraft;after:opencomputers@[1.7.1.43,)", guiFactory="erogenousbeef.bigreactors.client.config.ConfigFactory")
public class BigReactors
implements IModInitializationHandler {
    public static final String NAME = "Extreme Reactors";
    public static final String MODID = "bigreactors";
    public static final int WORLDGEN_VERSION = 1;
    public static final Config CONFIG;
    public static final CreativeTabs TAB;
    public static final IWorldGenWhiteList WHITELIST_WORLDGEN_ORES;
    public static final WorldGenMinableOres WORLDGEN_ORES;
    public static final WorldGenMinableOres NETHER_ORES;
    public static final WorldGenMinableOres END_ORES;
    public static final BigReactorsTickHandler TICK_HANDLER;
    public static final boolean VALENTINES_DAY;
    private final ObjectsHandler _objectsHandler = new ObjectsHandler(CONFIG);
    @Mod.Instance(value="bigreactors")
    private static BigReactors s_instance;
    @SidedProxy(clientSide="erogenousbeef.bigreactors.client.ClientProxy", serverSide="erogenousbeef.bigreactors.common.CommonProxy")
    private static CommonProxy s_proxy;
    private static Logger s_modLogger;

    public static BigReactors getInstance() {
        return s_instance;
    }

    public static CommonProxy getProxy() {
        return s_proxy;
    }

    public static Logger getLogger() {
        if (null == s_modLogger) {
            s_modLogger = LogManager.getLogger((String)MODID);
        }
        return s_modLogger;
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        this._objectsHandler.onPreInit(event);
        StandardReactants.register();
        MinecraftForge.EVENT_BUS.register((Object)new BREventHandler());
        MinecraftForge.EVENT_BUS.register((Object)s_proxy);
        s_proxy.onPreInit(event);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        this._objectsHandler.onInit(event);
        if (BigReactors.CONFIG.enableWorldGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)WORLDGEN_ORES, (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)NETHER_ORES, (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)END_ORES, (int)0);
            MinecraftForge.EVENT_BUS.register((Object)TICK_HANDLER);
        }
        CommonPacketHandler.init();
        new ModGuiHandler((Object)s_instance);
        s_proxy.onInit(event);
        this.registerGameBalanceData();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        this._objectsHandler.onPostInit(event);
        s_proxy.onPostInit(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        if (CodeHelper.runningInDevEnv()) {
            event.registerServerCommand((ICommand)new DebugCommand());
        }
    }

    private void registerGameBalanceData() {
        StandardReactants.yelloriumMapping = Reactants.registerSolid("ingotYellorium", "yellorium");
        StandardReactants.cyaniteMapping = Reactants.registerSolid("ingotCyanite", "cyanite");
        Reactants.registerSolid("ingotBlutonium", "blutonium");
        Reactants.registerSolid(BrBlocks.blockMetals.createItemStack(MetalType.Yellorium, 1), "yellorium", 9000);
        Reactants.registerSolid(BrBlocks.blockMetals.createItemStack(MetalType.Blutonium, 1), "blutonium", 9000);
        Reactants.registerFluid(BrFluids.fluidYellorium, "yellorium");
        Reactants.registerFluid(BrFluids.fluidCyanite, "cyanite");
        ReactorConversions.register("yellorium", "cyanite");
        ReactorConversions.register("blutonium", "cyanite");
        boolean enableFantasyMetals = BigReactors.CONFIG.enableMetallurgyFantasyMetalsInTurbines;
        boolean enableComedy = BigReactors.CONFIG.enableComedy;
        TurbineCoil.registerBlock("blockIron", 1.0f, 1.0f, 1.0f);
        TurbineCoil.registerBlock("blockGold", 2.0f, 1.0f, 1.75f);
        TurbineCoil.registerBlock("blockCopper", 1.2f, 1.0f, 1.2f);
        TurbineCoil.registerBlock("blockOsmium", 1.2f, 1.0f, 1.2f);
        TurbineCoil.registerBlock("blockCobalt", 1.2f, 1.0f, 1.2f);
        TurbineCoil.registerBlock("blockZinc", 1.35f, 1.0f, 1.3f);
        TurbineCoil.registerBlock("blockArdite", 1.35f, 1.0f, 1.3f);
        TurbineCoil.registerBlock("blockLead", 1.35f, 1.01f, 1.3f);
        TurbineCoil.registerBlock("blockBrass", 1.4f, 1.0f, 1.2f);
        TurbineCoil.registerBlock("blockAlubrass", 1.4f, 1.0f, 1.2f);
        TurbineCoil.registerBlock("blockBronze", 1.4f, 1.0f, 1.2f);
        TurbineCoil.registerBlock("blockAluminum", 1.5f, 1.0f, 1.3f);
        TurbineCoil.registerBlock("blockSteel", 1.5f, 1.0f, 1.3f);
        TurbineCoil.registerBlock("blockInvar", 1.5f, 1.0f, 1.4f);
        TurbineCoil.registerBlock("blockSilver", 1.7f, 1.0f, 1.5f);
        TurbineCoil.registerBlock("blockElectrum", 2.5f, 1.0f, 2.0f);
        TurbineCoil.registerBlock("blockElectrumFlux", 2.5f, 1.01f, 2.2f);
        TurbineCoil.registerBlock("blockPlatinum", 3.0f, 1.0f, 2.5f);
        TurbineCoil.registerBlock("blockShiny", 3.0f, 1.0f, 2.5f);
        TurbineCoil.registerBlock("blockManyullyn", 3.5f, 1.0f, 2.5f);
        TurbineCoil.registerBlock("blockTitanium", 3.1f, 1.0f, 2.7f);
        TurbineCoil.registerBlock("blockEnderium", 3.0f, 1.02f, 3.0f);
        TurbineCoil.registerBlock("blockLudicrite", 3.5f, 1.02f, 3.5f);
        if (enableFantasyMetals) {
            TurbineCoil.registerBlock("blockMithril", 2.2f, 1.0f, 1.5f);
            TurbineCoil.registerBlock("blockOrichalcum", 2.3f, 1.0f, 1.7f);
            TurbineCoil.registerBlock("blockQuicksilver", 2.6f, 1.0f, 1.8f);
            TurbineCoil.registerBlock("blockHaderoth", 3.0f, 1.0f, 2.0f);
            TurbineCoil.registerBlock("blockCelenegil", 3.3f, 1.0f, 2.25f);
            TurbineCoil.registerBlock("blockTartarite", 3.5f, 1.0f, 2.5f);
        }
        ReactorInterior.registerBlock("blockIron", 0.5f, 0.75f, 1.4f, 0.6f);
        ReactorInterior.registerBlock("blockGold", 0.52f, 0.8f, 1.45f, 2.0f);
        ReactorInterior.registerBlock("blockDiamond", 0.55f, 0.85f, 1.5f, 3.0f);
        ReactorInterior.registerBlock("blockEmerald", 0.55f, 0.85f, 1.5f, 2.5f);
        ReactorInterior.registerBlock("blockGraphite", 0.1f, 0.5f, 2.0f, 2.0f);
        ReactorInterior.registerBlock("blockGlassColorless", 0.2f, 0.25f, 1.1f, 0.3f);
        ReactorInterior.registerBlock("blockIce", 0.33f, 0.33f, 1.15f, 0.1f);
        ReactorInterior.registerBlock("blockSnow", 0.15f, 0.33f, 1.05f, 0.05f);
        ReactorInterior.registerBlock("blockCopper", 0.5f, 0.75f, 1.4f, 1.0f);
        ReactorInterior.registerBlock("blockOsmium", 0.51f, 0.77f, 1.41f, 1.0f);
        ReactorInterior.registerBlock("blockBrass", 0.51f, 0.77f, 1.41f, 1.0f);
        ReactorInterior.registerBlock("blockBronze", 0.51f, 0.77f, 1.41f, 1.0f);
        ReactorInterior.registerBlock("blockZinc", 0.51f, 0.77f, 1.41f, 1.0f);
        ReactorInterior.registerBlock("blockAluminum", 0.5f, 0.78f, 1.42f, 0.6f);
        ReactorInterior.registerBlock("blockSteel", 0.5f, 0.78f, 1.42f, 0.6f);
        ReactorInterior.registerBlock("blockInvar", 0.5f, 0.79f, 1.43f, 0.6f);
        ReactorInterior.registerBlock("blockSilver", 0.51f, 0.79f, 1.43f, 1.5f);
        ReactorInterior.registerBlock("blockLead", 0.75f, 0.75f, 1.75f, 1.5f);
        ReactorInterior.registerBlock("blockElectrum", 0.53f, 0.82f, 1.47f, 2.2f);
        ReactorInterior.registerBlock("blockElectrumFlux", 0.54f, 0.83f, 1.48f, 2.4f);
        ReactorInterior.registerBlock("blockPlatinum", 0.57f, 0.86f, 1.58f, 2.5f);
        ReactorInterior.registerBlock("blockShiny", 0.57f, 0.86f, 1.58f, 2.5f);
        ReactorInterior.registerBlock("blockTitanium", 0.58f, 0.87f, 1.59f, 2.7f);
        ReactorInterior.registerBlock("blockEnderium", 0.6f, 0.88f, 1.6f, 3.0f);
        ReactorInterior.registerBlock("blockDraconium", 0.59f, 0.88f, 1.6f, 3.3f);
        ReactorInterior.registerBlock("blockDraconiumAwakened", 0.76f, 0.88f, 1.78f, 4.8f);
        if (enableFantasyMetals) {
            ReactorInterior.registerBlock("blockMithril", 0.53f, 0.81f, 1.45f, 1.5f);
            ReactorInterior.registerBlock("blockOrichalcum", 0.52f, 0.83f, 1.46f, 1.7f);
            ReactorInterior.registerBlock("blockQuicksilver", 0.53f, 0.84f, 1.48f, 2.0f);
            ReactorInterior.registerBlock("blockHaderoth", 0.54f, 0.84f, 1.49f, 2.5f);
            ReactorInterior.registerBlock("blockCelenegil", 0.54f, 0.84f, 1.49f, 3.0f);
            ReactorInterior.registerBlock("blockTartarite", 0.65f, 0.9f, 1.62f, 4.0f);
            ReactorInterior.registerBlock("blockManyullyn", 0.68f, 0.88f, 1.75f, 4.5f);
        }
        ReactorInterior.registerFluid("water", RadiationHelper.waterData.absorption, RadiationHelper.waterData.heatEfficiency, RadiationHelper.waterData.moderation, 0.1f);
        ReactorInterior.registerFluid("redstone", 0.75f, 0.55f, 1.6f, 2.5f);
        ReactorInterior.registerFluid("liquidredstone", 0.65f, 0.45f, 1.5f, 2.5f);
        ReactorInterior.registerFluid("fluidtesla", 0.75f, 0.55f, 1.6f, 2.5f);
        ReactorInterior.registerFluid("glowstone", 0.2f, 0.6f, 1.75f, 1.0f);
        ReactorInterior.registerFluid("liquidglowstone", 0.18f, 0.5f, 1.55f, 1.0f);
        ReactorInterior.registerFluid("cryotheum", 0.66f, 0.95f, 6.0f, 3.0f);
        ReactorInterior.registerFluid("ender", 0.9f, 0.75f, 2.0f, 2.0f);
        ReactorInterior.registerFluid("liquidenderpearl", 0.75f, 0.6f, 1.8f, 2.0f);
        ReactorInterior.registerFluid("pyrotheum", 0.66f, 0.9f, 1.0f, 0.6f);
        ReactorInterior.registerFluid("lifeessence", 0.7f, 0.55f, 1.75f, 2.0f);
        if (enableComedy) {
            ReactorInterior.registerFluid("blueslime", 0.33f, 0.5f, 1.35f, 2.0f);
            ReactorInterior.registerFluid("purpleslime", 0.56f, 0.75f, 1.65f, 2.0f);
            ReactorInterior.registerBlock("blockMeat", 0.5f, 0.33f, 1.33f, 0.15f);
            ReactorInterior.registerBlock("blockMeatRaw", 0.4f, 0.5f, 1.5f, 0.15f);
            ReactorInterior.registerFluid("meat", 0.4f, 0.6f, 1.33f, 0.15f);
            ReactorInterior.registerFluid("pinkSlime", 0.45f, 0.7f, 1.5f, 0.6f);
            ReactorInterior.registerFluid("sewage", 0.5f, 0.65f, 1.44f, 0.6f);
        }
    }

    public static ResourceLocation createResourceLocation(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static ResourceLocation createGuiResourceLocation(String path) {
        return BigReactors.createResourceLocation("textures/gui/" + path);
    }

    public static ResourceLocation createBlockResourceLocation(String path) {
        return BigReactors.createResourceLocation("blocks/" + path);
    }

    public static void temp_sendStatusMessage(@Nonnull EntityPlayer player, @Nonnull ITextComponent message) {
        BigReactors.getProxy().temp_sendPlayerStatusMessage(player, message);
    }

    static {
        FluidRegistry.enableUniversalBucket();
        CONFIG = new Config();
        WHITELIST_WORLDGEN_ORES = new WorldGenWhiteList();
        WORLDGEN_ORES = new WorldGenMinableOres(WHITELIST_WORLDGEN_ORES);
        TICK_HANDLER = new BigReactorsTickHandler(WORLDGEN_ORES);
        WorldGenWhiteList whiteList = new WorldGenWhiteList();
        whiteList.whiteListDimension(-1);
        NETHER_ORES = new WorldGenMinableOres((IWorldGenWhiteList)whiteList);
        whiteList = new WorldGenWhiteList();
        whiteList.whiteListDimension(1);
        END_ORES = new WorldGenMinableOres((IWorldGenWhiteList)whiteList);
        TAB = new CreativeTabBR(MODID);
        Calendar calendar = Calendar.getInstance();
        VALENTINES_DAY = calendar.get(2) == 1 && calendar.get(5) == 14;
    }
}

