/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

@RitualRegister(value="speed")
public class RitualSpeed
extends Ritual {
    public static final String SPEED_RANGE = "sanicRange";
    public static final double vengefulWillDrain = 0.05;
    public static final double destructiveWillDrain = 0.05;
    public static final double rawWillDrain = 0.1;

    public RitualSpeed() {
        super("ritualSpeed", 0, 1000, "ritual.bloodmagic.speedRitual");
        this.addBlockRange(SPEED_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 1, -2), new BlockPos(2, 5, 2)));
        this.setMaximumVolumeAndDistanceOfRange(SPEED_RANGE, 0, 2, 5);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        AreaDescriptor speedRange = this.getBlockRange(SPEED_RANGE);
        double vengefulDrain = 0.0;
        double destructiveDrain = 0.0;
        double rawDrain = 0.0;
        if (rawWill < 0.1) {
            rawWill = 0.0;
        }
        for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, speedRange.getAABB(masterRitualStone.getBlockPos()))) {
            boolean transportAdults;
            if (entity.func_70093_af()) continue;
            boolean transportChildren = destructiveWill < 0.05;
            boolean bl = transportAdults = vengefulWill < 0.05;
            if (entity.func_70631_g_() && !transportChildren || !entity.func_70631_g_() && !transportAdults || entity instanceof EntityPlayer && transportChildren ^ transportAdults) continue;
            if (!transportChildren) {
                destructiveWill -= 0.05;
                destructiveDrain += 0.05;
            }
            if (!transportAdults) {
                vengefulWill -= 0.05;
                vengefulDrain += 0.05;
            }
            double motionY = this.getVerticalSpeedForWill(rawWill);
            double speed = this.getHorizontalSpeedForWill(rawWill);
            EnumFacing direction = masterRitualStone.getDirection();
            if (rawWill >= 0.1) {
                rawWill -= 0.1;
                rawDrain += 0.1;
            }
            entity.field_70181_x = motionY;
            entity.field_70143_R = 0.0f;
            switch (direction) {
                case NORTH: {
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = -speed;
                    break;
                }
                case SOUTH: {
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = speed;
                    break;
                }
                case WEST: {
                    entity.field_70159_w = -speed;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = 0.0;
                    break;
                }
                case EAST: {
                    entity.field_70159_w = speed;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = 0.0;
                    break;
                }
            }
            if (!(entity instanceof EntityPlayer)) continue;
            Utils.setPlayerSpeedFromServer((EntityPlayer)entity, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        }
        if (rawDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrain, true);
        }
        if (vengefulDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrain, true);
        }
        if (destructiveDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveDrain, true);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -2, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, -1, EnumRuneType.AIR);
        for (int i = 0; i < 3; ++i) {
            this.addRune(components, 2, 0, i, EnumRuneType.AIR);
            this.addRune(components, -2, 0, i, EnumRuneType.AIR);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSpeed();
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(EntityPlayer player) {
        return new ITextComponent[]{new TextComponentTranslation(this.getUnlocalizedName() + ".info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".default.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".corrosive.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".steadfast.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".destructive.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".vengeful.info", new Object[0])};
    }

    public double getVerticalSpeedForWill(double rawWill) {
        return 1.2 + rawWill / 200.0;
    }

    public double getHorizontalSpeedForWill(double rawWill) {
        return 3.0 + rawWill / 40.0;
    }
}

