/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;

@RitualRegister(value="expulsion")
public class RitualExpulsion
extends Ritual {
    public static final String EXPULSION_RANGE = "expulsionRange";

    public RitualExpulsion() {
        super("ritualExpulsion", 0, 10000, "ritual.bloodmagic.expulsionRitual");
        this.addBlockRange(EXPULSION_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-12, 0, -12), 25));
        this.setMaximumVolumeAndDistanceOfRange(EXPULSION_RANGE, 0, 12, 12);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        IItemHandler handler;
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        if (masterRitualStone.getWorldObj().field_72995_K) {
            return;
        }
        AreaDescriptor expulsionRange = this.getBlockRange(EXPULSION_RANGE);
        ArrayList whitelist = Lists.newArrayList();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        TileEntity tile = world.func_175625_s(masterPos.func_177984_a());
        if (tile != null && (handler = Utils.getInventory(tile, null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                Binding binding;
                ItemStack itemStack = handler.getStackInSlot(i);
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IBindable) || (binding = ((IBindable)itemStack.func_77973_b()).getBinding(itemStack)) == null || whitelist.contains(binding.getOwnerId())) continue;
                whitelist.add(binding.getOwnerId());
            }
        }
        int teleportDistance = 100;
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, expulsionRange.getAABB(masterRitualStone.getBlockPos()))) {
            if (player.field_71075_bZ.field_75098_d || player.func_146103_bH().getId().equals(masterRitualStone.getOwner()) || whitelist.contains(player.func_146103_bH().getId()) || !this.teleportRandomly((EntityLivingBase)player, 100.0)) continue;
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * 1000));
        }
        whitelist.clear();
    }

    public boolean teleportRandomly(EntityLivingBase entityLiving, double distance) {
        int i;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
        }
        double x = entityLiving.field_70165_t;
        double y = entityLiving.field_70163_u;
        double z = entityLiving.field_70161_v;
        Random rand = new Random();
        double randX = x + (rand.nextDouble() - 0.5) * distance;
        double randY = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
        double randZ = z + (rand.nextDouble() - 0.5) * distance;
        for (i = 0; !this.teleportTo(entityLiving, randX, randY, randZ, x, y, z) && i < 100; ++i) {
            randX = x + (rand.nextDouble() - 0.5) * distance;
            randY = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
            randZ = z + (rand.nextDouble() - 0.5) * distance;
        }
        return i >= 100;
    }

    public boolean teleportTo(EntityLivingBase entityLiving, double par1, double par3, double par5, double lastX, double lastY, double lastZ) {
        EnderTeleportEvent event = new EnderTeleportEvent(entityLiving, par1, par3, par5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        this.moveEntityViaTeleport(entityLiving, event.getTargetX(), event.getTargetY(), event.getTargetZ());
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)entityLiving.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityLiving.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityLiving.field_70161_v);
        if (!entityLiving.func_130014_f_().func_175623_d(new BlockPos(i, j, k))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                IBlockState state = entityLiving.func_130014_f_().func_180495_p(new BlockPos(i, j - 1, k));
                if (state.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entityLiving.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.moveEntityViaTeleport(entityLiving, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                if (!entityLiving.field_70132_H && !entityLiving.func_130014_f_().func_72953_d(entityLiving.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.moveEntityViaTeleport(entityLiving, lastX, lastY, lastZ);
            return false;
        }
        for (int l = 0; l < 128; ++l) {
            double lengthVal = (double)l / 127.0;
            float randF1 = (entityLiving.func_130014_f_().field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float randF2 = (entityLiving.func_130014_f_().field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float randF3 = (entityLiving.func_130014_f_().field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double lengthValX = lastX + (entityLiving.field_70165_t - lastX) * lengthVal + (entityLiving.func_130014_f_().field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            double lengthValY = lastY + (entityLiving.field_70163_u - lastY) * lengthVal + entityLiving.func_130014_f_().field_73012_v.nextDouble() * (double)entityLiving.field_70131_O;
            double lengthValZ = lastZ + (entityLiving.field_70161_v - lastZ) * lengthVal + (entityLiving.func_130014_f_().field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            entityLiving.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, lengthValX, lengthValY, lengthValZ, (double)randF1, (double)randF2, (double)randF3, new int[0]);
        }
        return true;
    }

    public void moveEntityViaTeleport(EntityLivingBase entityLiving, double x, double y, double z) {
        if (entityLiving instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityLiving;
            EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)player, x, y, z, 5.0f);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (entityLiving.func_184218_aH()) {
                    player.func_71123_m();
                }
                entityLiving.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            }
        } else if (entityLiving != null) {
            entityLiving.func_70107_b(x, y, z);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addRune(components, 2, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 1, 0, 2, EnumRuneType.EARTH);
        this.addRune(components, 2, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, 2, EnumRuneType.EARTH);
        this.addRune(components, -2, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 1, 0, -2, EnumRuneType.EARTH);
        this.addRune(components, -2, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, -2, EnumRuneType.EARTH);
        this.addRune(components, 4, 0, 2, EnumRuneType.AIR);
        this.addRune(components, 5, 0, 2, EnumRuneType.AIR);
        this.addRune(components, 4, 0, -2, EnumRuneType.AIR);
        this.addRune(components, 5, 0, -2, EnumRuneType.AIR);
        this.addRune(components, -4, 0, 2, EnumRuneType.AIR);
        this.addRune(components, -5, 0, 2, EnumRuneType.AIR);
        this.addRune(components, -4, 0, -2, EnumRuneType.AIR);
        this.addRune(components, -5, 0, -2, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 4, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 5, EnumRuneType.AIR);
        this.addRune(components, -2, 0, 4, EnumRuneType.AIR);
        this.addRune(components, -2, 0, 5, EnumRuneType.AIR);
        this.addRune(components, 2, 0, -4, EnumRuneType.AIR);
        this.addRune(components, 2, 0, -5, EnumRuneType.AIR);
        this.addRune(components, -2, 0, -4, EnumRuneType.AIR);
        this.addRune(components, -2, 0, -5, EnumRuneType.AIR);
        this.addParallelRunes(components, 5, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 6, 0, EnumRuneType.EARTH);
        this.addRune(components, -6, 0, 1, EnumRuneType.DUSK);
        this.addRune(components, -6, 0, -1, EnumRuneType.DUSK);
        this.addRune(components, 6, 0, 1, EnumRuneType.DUSK);
        this.addRune(components, 6, 0, -1, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, 6, EnumRuneType.DUSK);
        this.addRune(components, -1, 0, 6, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, -6, EnumRuneType.DUSK);
        this.addRune(components, -1, 0, -6, EnumRuneType.DUSK);
        this.addCornerRunes(components, 4, 0, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualExpulsion();
    }
}

