/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.gear;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.altar.IAltarManipulator;
import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.iface.IItemLPContainer;
import WayofTime.bloodmagic.util.helper.ItemHelper;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemPackSacrifice
extends ItemArmor
implements IAltarManipulator,
IItemLPContainer,
IVariantProvider {
    public final int CAPACITY = 10000;

    public ItemPackSacrifice() {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, EntityEquipmentSlot.CHEST);
        this.func_77655_b("bloodmagic.pack.sacrifice");
        this.func_77637_a(BloodMagic.TAB_BM);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null) {
            return super.func_77659_a(world, player, EnumHand.MAIN_HAND);
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile = world.func_175625_s(rayTrace.func_178782_a());
            if (!(tile instanceof IBloodAltar)) {
                return super.func_77659_a(world, player, EnumHand.MAIN_HAND);
            }
            ItemHelper.LPContainer.tryAndFillAltar((IBloodAltar)tile, stack, world, rayTrace.func_178782_a());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (this.getStoredLP(stack) > 10000) {
            this.setStoredLP(stack, 10000);
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        list.add(TextHelper.localize("tooltip.bloodmagic.pack.sacrifice.desc", new Object[0]));
        list.add(TextHelper.localize("tooltip.bloodmagic.pack.stored", this.getStoredLP(stack)));
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=normal");
    }

    @Override
    public int getCapacity() {
        return this.CAPACITY;
    }

    @Override
    public int getStoredLP(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT(stack).func_77978_p().func_74762_e("storedLP") : 0;
    }

    @Override
    public void setStoredLP(ItemStack stack, int lp) {
        if (stack != null) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74768_a("storedLP", lp);
        }
    }
}

