/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.handler.event.ClientHandler;
import WayofTime.bloodmagic.util.helper.RitualHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemRitualDiviner
extends Item
implements IVariantProvider {
    public static final String tooltipBase = "tooltip.bloodmagic.diviner.";
    public static String[] names = new String[]{"normal", "dusk", "dawn"};

    public ItemRitualDiviner() {
        this.func_77655_b("bloodmagic.ritualDiviner");
        this.func_77637_a(BloodMagic.TAB_BM);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[stack.func_77952_i()];
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        if (Strings.isNullOrEmpty((String)this.getCurrentRitual(stack))) {
            return displayName;
        }
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(stack));
        if (ritual == null) {
            return displayName;
        }
        return displayName + ": " + TextHelper.localize(ritual.getUnlocalizedName(), new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            list.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (world.field_72995_K) {
                this.trySetDisplayedRitual(stack, world, pos);
            }
            return EnumActionResult.SUCCESS;
        }
        if (this.addRuneToRitual(stack, world, pos, player)) {
            if (world.field_72995_K) {
                ItemRitualDiviner.spawnParticles(world, pos.func_177984_a(), 15);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean addRuneToRitual(ItemStack stack, World world, BlockPos pos, EntityPlayer player) {
        Ritual ritual;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone && (ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(stack))) != null) {
            EnumFacing direction = this.getDirection(stack);
            ArrayList components = Lists.newArrayList();
            ritual.gatherComponents(components::add);
            for (RitualComponent component : components) {
                if (!this.canPlaceRitualStone(component.getRuneType(), stack)) {
                    return false;
                }
                BlockPos offset = component.getOffset(direction);
                BlockPos newPos = pos.func_177971_a((Vec3i)offset);
                IBlockState state = world.func_180495_p(newPos);
                Block block = state.func_177230_c();
                if (RitualHelper.isRune(world, newPos)) {
                    if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) {
                        if (!world.field_72995_K) continue;
                        this.undisplayHologram();
                        continue;
                    }
                    RitualHelper.setRuneType(world, newPos, component.getRuneType());
                    return true;
                }
                if (block.isAir(state, (IBlockAccess)world, newPos) || block.func_176200_f((IBlockAccess)world, newPos)) {
                    if (!this.consumeStone(stack, world, player)) {
                        return false;
                    }
                    int meta = component.getRuneType().ordinal();
                    IBlockState newState = RegistrarBloodMagicBlocks.RITUAL_STONE.func_176203_a(meta);
                    world.func_175656_a(newPos, newState);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void trySetDisplayedRitual(ItemStack itemStack, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(itemStack));
            TileMasterRitualStone masterRitualStone = (TileMasterRitualStone)tile;
            if (ritual != null) {
                EnumFacing direction = this.getDirection(itemStack);
                ClientHandler.setRitualHolo(masterRitualStone, ritual, direction, true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void undisplayHologram() {
        ClientHandler.setRitualHoloToNull();
    }

    public boolean consumeStone(ItemStack stack, World world, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        NonNullList inventory = player.field_71071_by.field_70462_a;
        for (ItemStack newStack : inventory) {
            Block block;
            Item item;
            if (newStack.func_190926_b() || !((item = newStack.func_77973_b()) instanceof ItemBlock) || (block = ((ItemBlock)item).func_179223_d()) != RegistrarBloodMagicBlocks.RITUAL_STONE) continue;
            newStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(stack));
        if (ritual != null) {
            boolean extraInfo;
            tooltip.add(TextHelper.localize("tooltip.bloodmagic.diviner.currentRitual", TextHelper.localize(ritual.getUnlocalizedName(), new Object[0])));
            boolean sneaking = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
            boolean bl = extraInfo = sneaking && Keyboard.isKeyDown((int)50);
            if (extraInfo) {
                tooltip.add("");
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    if (!TextHelper.canTranslate(ritual.getUnlocalizedName() + "." + type.func_176610_l().toLowerCase() + ".info")) continue;
                    tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect(ritual.getUnlocalizedName() + "." + type.func_176610_l().toLowerCase() + ".info", new Object[0]))));
                }
            } else if (sneaking) {
                tooltip.add(TextHelper.localize("tooltip.bloodmagic.diviner.currentDirection", Utils.toFancyCasing(this.getDirection(stack).func_176610_l())));
                tooltip.add("");
                ArrayList components = Lists.newArrayList();
                ritual.gatherComponents(components::add);
                int blankRunes = 0;
                int airRunes = 0;
                int waterRunes = 0;
                int fireRunes = 0;
                int earthRunes = 0;
                int duskRunes = 0;
                int dawnRunes = 0;
                int totalRunes = components.size();
                for (RitualComponent component : components) {
                    switch (component.getRuneType()) {
                        case BLANK: {
                            ++blankRunes;
                            break;
                        }
                        case AIR: {
                            ++airRunes;
                            break;
                        }
                        case EARTH: {
                            ++earthRunes;
                            break;
                        }
                        case FIRE: {
                            ++fireRunes;
                            break;
                        }
                        case WATER: {
                            ++waterRunes;
                            break;
                        }
                        case DUSK: {
                            ++duskRunes;
                            break;
                        }
                        case DAWN: {
                            ++dawnRunes;
                        }
                    }
                }
                if (blankRunes > 0) {
                    tooltip.add(EnumRuneType.BLANK.colorCode + TextHelper.localize("tooltip.bloodmagic.diviner.blankRune", blankRunes));
                }
                if (waterRunes > 0) {
                    tooltip.add(EnumRuneType.WATER.colorCode + TextHelper.localize("tooltip.bloodmagic.diviner.waterRune", waterRunes));
                }
                if (airRunes > 0) {
                    tooltip.add(EnumRuneType.AIR.colorCode + TextHelper.localize("tooltip.bloodmagic.diviner.airRune", airRunes));
                }
                if (fireRunes > 0) {
                    tooltip.add(EnumRuneType.FIRE.colorCode + TextHelper.localize("tooltip.bloodmagic.diviner.fireRune", fireRunes));
                }
                if (earthRunes > 0) {
                    tooltip.add(EnumRuneType.EARTH.colorCode + TextHelper.localize("tooltip.bloodmagic.diviner.earthRune", earthRunes));
                }
                if (duskRunes > 0) {
                    tooltip.add(EnumRuneType.DUSK.colorCode + TextHelper.localize("tooltip.bloodmagic.diviner.duskRune", duskRunes));
                }
                if (dawnRunes > 0) {
                    tooltip.add(EnumRuneType.DAWN.colorCode + TextHelper.localize("tooltip.bloodmagic.diviner.dawnRune", dawnRunes));
                }
                tooltip.add("");
                tooltip.add(TextHelper.localize("tooltip.bloodmagic.diviner.totalRune", totalRunes));
            } else {
                tooltip.add("");
                if (TextHelper.canTranslate(ritual.getUnlocalizedName() + ".info")) {
                    tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect(ritual.getUnlocalizedName() + ".info", new Object[0]))));
                    tooltip.add("");
                }
                tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.diviner.extraInfo", new Object[0]));
                tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.diviner.extraExtraInfo", new Object[0]));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult ray = this.func_77621_a(world, player, false);
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.cycleRitual(stack, player, false);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            RayTraceResult ray = this.func_77621_a(player.func_130014_f_(), player, false);
            if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
                return false;
            }
            if (!player.field_82175_bq) {
                if (player.func_70093_af()) {
                    this.cycleRitual(stack, player, true);
                } else {
                    this.cycleDirection(stack, player);
                }
            }
        }
        return false;
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=basic");
        variants.put(1, (Object)"type=dusk");
        variants.put(2, (Object)"type=dawn");
    }

    public void cycleDirection(ItemStack stack, EntityPlayer player) {
        EnumFacing newDirection;
        EnumFacing direction = this.getDirection(stack);
        switch (direction) {
            case NORTH: {
                newDirection = EnumFacing.EAST;
                break;
            }
            case EAST: {
                newDirection = EnumFacing.SOUTH;
                break;
            }
            case SOUTH: {
                newDirection = EnumFacing.WEST;
                break;
            }
            case WEST: {
                newDirection = EnumFacing.NORTH;
                break;
            }
            default: {
                newDirection = EnumFacing.NORTH;
            }
        }
        this.setDirection(stack, newDirection);
        this.notifyDirectionChange(newDirection, player);
    }

    public void notifyDirectionChange(EnumFacing direction, EntityPlayer player) {
        player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.bloodmagic.diviner.currentDirection", new Object[]{Utils.toFancyCasing(direction.name())}), true);
    }

    public void setDirection(ItemStack stack, EnumFacing direction) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a("direction", direction.func_176745_a());
    }

    public EnumFacing getDirection(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return EnumFacing.NORTH;
        }
        NBTTagCompound tag = stack.func_77978_p();
        int dir = tag.func_74762_e("direction");
        if (dir == 0) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.field_82609_l[tag.func_74762_e("direction")];
    }

    public void cycleRitual(ItemStack stack, EntityPlayer player, boolean reverse) {
        String key = this.getCurrentRitual(stack);
        ArrayList rituals = BloodMagic.RITUAL_MANAGER.getSortedRituals();
        if (reverse) {
            rituals = Lists.newArrayList(rituals);
            Collections.reverse(rituals);
        }
        String firstId = "";
        boolean foundId = false;
        boolean foundFirst = false;
        for (Ritual ritual : rituals) {
            String id = BloodMagic.RITUAL_MANAGER.getId(ritual);
            if (!BloodMagic.RITUAL_MANAGER.enabled(id, false) || !this.canDivinerPerformRitual(stack, ritual)) continue;
            if (!foundFirst) {
                firstId = id;
                foundFirst = true;
            }
            if (foundId) {
                this.setCurrentRitual(stack, id);
                this.notifyRitualChange(id, player);
                return;
            }
            if (!id.equals(key)) continue;
            foundId = true;
        }
        if (foundFirst) {
            this.setCurrentRitual(stack, firstId);
            this.notifyRitualChange(firstId, player);
        }
    }

    public boolean canDivinerPerformRitual(ItemStack stack, Ritual ritual) {
        if (ritual == null) {
            return false;
        }
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent component : components) {
            if (this.canPlaceRitualStone(component.getRuneType(), stack)) continue;
            return false;
        }
        return true;
    }

    public void notifyRitualChange(String key, EntityPlayer player) {
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(key);
        if (ritual != null) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(ritual.getUnlocalizedName(), new Object[0]), true);
        }
    }

    public void setCurrentRitual(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("current_ritual", key);
    }

    public String getCurrentRitual(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74779_i("current_ritual");
    }

    public boolean canPlaceRitualStone(EnumRuneType rune, ItemStack stack) {
        int meta = stack.func_77952_i();
        switch (rune) {
            case BLANK: 
            case AIR: 
            case EARTH: 
            case FIRE: 
            case WATER: {
                return true;
            }
            case DUSK: {
                return meta >= 1;
            }
            case DAWN: {
                return meta >= 2;
            }
        }
        return false;
    }

    public static void spawnParticles(World worldIn, BlockPos pos, int amount) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block.isAir(state, (IBlockAccess)worldIn, pos)) {
            for (int i = 0; i < amount; ++i) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat(), (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2, new int[0]);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2, new int[0]);
            }
        }
    }
}

