/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.impl;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.altar.ComponentType;
import WayofTime.bloodmagic.api.BloodMagicPlugin;
import WayofTime.bloodmagic.api.IBloodMagicAPI;
import WayofTime.bloodmagic.api.IBloodMagicPlugin;
import WayofTime.bloodmagic.api.IBloodMagicRecipeRegistrar;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.BloodMagicRecipeRegistrar;
import WayofTime.bloodmagic.block.BlockBloodRune;
import WayofTime.bloodmagic.block.BlockDecorative;
import WayofTime.bloodmagic.block.enums.BloodRuneType;
import WayofTime.bloodmagic.block.enums.EnumDecorative;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.core.RegistrarBloodMagicRecipes;
import WayofTime.bloodmagic.incense.EnumTranquilityType;
import WayofTime.bloodmagic.incense.TranquilityStack;
import WayofTime.bloodmagic.util.StateUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@BloodMagicPlugin
public class BloodMagicCorePlugin
implements IBloodMagicPlugin {
    @Override
    public void register(IBloodMagicAPI apiInterface) {
        BloodMagicAPI api = (BloodMagicAPI)apiInterface;
        api.getBlacklist().addTeleposer(RegistrarBloodMagicBlocks.INPUT_ROUTING_NODE);
        api.getBlacklist().addTransposition(RegistrarBloodMagicBlocks.INPUT_ROUTING_NODE);
        api.getBlacklist().addTeleposer(RegistrarBloodMagicBlocks.OUTPUT_ROUTING_NODE);
        api.getBlacklist().addTransposition(RegistrarBloodMagicBlocks.OUTPUT_ROUTING_NODE);
        api.getBlacklist().addTeleposer(RegistrarBloodMagicBlocks.ITEM_ROUTING_NODE);
        api.getBlacklist().addTransposition(RegistrarBloodMagicBlocks.ITEM_ROUTING_NODE);
        api.getBlacklist().addTeleposer(RegistrarBloodMagicBlocks.MASTER_ROUTING_NODE);
        api.getBlacklist().addTransposition(RegistrarBloodMagicBlocks.MASTER_ROUTING_NODE);
        api.getBlacklist().addTeleposer(RegistrarBloodMagicBlocks.DEMON_CRYSTAL);
        api.getBlacklist().addTransposition(RegistrarBloodMagicBlocks.DEMON_CRYSTAL);
        api.getBlacklist().addTeleposer(RegistrarBloodMagicBlocks.INVERSION_PILLAR);
        api.getBlacklist().addTransposition(RegistrarBloodMagicBlocks.INVERSION_PILLAR);
        api.getBlacklist().addWellOfSuffering(new ResourceLocation("armor_stand"));
        api.getBlacklist().addWellOfSuffering(new ResourceLocation("bloodmagic", "sentient_specter"));
        api.getValueManager().setSacrificialValue(new ResourceLocation("armor_stand"), 0);
        api.getValueManager().setSacrificialValue(new ResourceLocation("bloodmagic", "sentient_specter"), 0);
        api.getValueManager().setTranquility((Block)Blocks.field_150353_l, new TranquilityStack(EnumTranquilityType.LAVA, 1.2));
        api.getValueManager().setTranquility((Block)Blocks.field_150356_k, new TranquilityStack(EnumTranquilityType.LAVA, 1.2));
        api.getValueManager().setTranquility((Block)Blocks.field_150355_j, new TranquilityStack(EnumTranquilityType.WATER, 1.0));
        api.getValueManager().setTranquility((Block)Blocks.field_150358_i, new TranquilityStack(EnumTranquilityType.WATER, 1.0));
        api.getValueManager().setTranquility(RegistrarBloodMagicBlocks.LIFE_ESSENCE, new TranquilityStack(EnumTranquilityType.WATER, 1.5));
        api.getValueManager().setTranquility(Blocks.field_150424_aL, new TranquilityStack(EnumTranquilityType.FIRE, 0.5));
        api.getValueManager().setTranquility(Blocks.field_150346_d, new TranquilityStack(EnumTranquilityType.EARTHEN, 0.25));
        api.getValueManager().setTranquility(Blocks.field_150458_ak, new TranquilityStack(EnumTranquilityType.EARTHEN, 1.0));
        api.getValueManager().setTranquility(Blocks.field_150469_bN, new TranquilityStack(EnumTranquilityType.CROP, 1.0));
        api.getValueManager().setTranquility(Blocks.field_150459_bM, new TranquilityStack(EnumTranquilityType.CROP, 1.0));
        api.getValueManager().setTranquility(Blocks.field_150464_aj, new TranquilityStack(EnumTranquilityType.CROP, 1.0));
        api.getValueManager().setTranquility(Blocks.field_150388_bm, new TranquilityStack(EnumTranquilityType.CROP, 1.0));
        api.getValueManager().setTranquility(Blocks.field_185773_cZ, new TranquilityStack(EnumTranquilityType.CROP, 1.0));
        BloodMagicCorePlugin.handleConfigValues(api);
        api.registerAltarComponent(Blocks.field_150426_aN.func_176223_P(), ComponentType.GLOWSTONE.name());
        api.registerAltarComponent(Blocks.field_180398_cJ.func_176223_P(), ComponentType.GLOWSTONE.name());
        api.registerAltarComponent(Blocks.field_150461_bJ.func_176223_P(), ComponentType.BEACON.name());
        BlockDecorative decorative = (BlockDecorative)RegistrarBloodMagicBlocks.DECORATIVE_BRICK;
        api.registerAltarComponent(decorative.func_176223_P().func_177226_a(decorative.getProperty(), (Comparable)((Object)EnumDecorative.BLOODSTONE_BRICK)), ComponentType.BLOODSTONE.name());
        api.registerAltarComponent(decorative.func_176223_P().func_177226_a(decorative.getProperty(), (Comparable)((Object)EnumDecorative.BLOODSTONE_TILE)), ComponentType.BLOODSTONE.name());
        api.registerAltarComponent(decorative.func_176223_P().func_177226_a(decorative.getProperty(), (Comparable)((Object)EnumDecorative.CRYSTAL_BRICK)), ComponentType.CRYSTAL.name());
        api.registerAltarComponent(decorative.func_176223_P().func_177226_a(decorative.getProperty(), (Comparable)((Object)EnumDecorative.CRYSTAL_TILE)), ComponentType.CRYSTAL.name());
        BlockBloodRune bloodRune = (BlockBloodRune)RegistrarBloodMagicBlocks.BLOOD_RUNE;
        for (BloodRuneType runeType : BloodRuneType.values()) {
            api.registerAltarComponent(bloodRune.func_176223_P().func_177226_a(bloodRune.getProperty(), (Comparable)((Object)runeType)), ComponentType.BLOODRUNE.name());
        }
    }

    @Override
    public void registerRecipes(IBloodMagicRecipeRegistrar recipeRegistrar) {
        RegistrarBloodMagicRecipes.registerAltarRecipes((BloodMagicRecipeRegistrar)recipeRegistrar);
        RegistrarBloodMagicRecipes.registerAlchemyTableRecipes((BloodMagicRecipeRegistrar)recipeRegistrar);
        RegistrarBloodMagicRecipes.registerTartaricForgeRecipes((BloodMagicRecipeRegistrar)recipeRegistrar);
        RegistrarBloodMagicRecipes.registerAlchemyArrayRecipes((BloodMagicRecipeRegistrar)recipeRegistrar);
        RegistrarBloodMagicRecipes.registerSacrificeCraftRecipes((BloodMagicRecipeRegistrar)recipeRegistrar);
    }

    private static void handleConfigValues(BloodMagicAPI api) {
        EntityEntry entityEntry;
        for (String value : ConfigHandler.values.sacrificialValues) {
            String[] split = value.split(";");
            if (split.length != 2) continue;
            api.getValueManager().setSacrificialValue(new ResourceLocation(split[0]), Integer.parseInt(split[1]));
        }
        for (String value : ConfigHandler.blacklist.teleposer) {
            entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(value));
            if (entityEntry == null) {
                String[] blockData = value.split("\\[");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockData[0]));
                if (block == Blocks.field_150350_a || block == null) continue;
                if (blockData.length > 1) {
                    api.getBlacklist().addTeleposer(StateUtil.parseState(value));
                    continue;
                }
                api.getBlacklist().addTeleposer(block);
                continue;
            }
            api.getBlacklist().addTeleposer(entityEntry.getRegistryName());
        }
        for (String value : ConfigHandler.blacklist.transposer) {
            String[] blockData = value.split("\\[");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockData[0]));
            if (block == Blocks.field_150350_a || block == null) continue;
            if (blockData.length > 1) {
                api.getBlacklist().addTeleposer(StateUtil.parseState(value));
                continue;
            }
            api.getBlacklist().addTeleposer(block);
        }
        for (String value : ConfigHandler.blacklist.wellOfSuffering) {
            entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(value));
            if (entityEntry == null) continue;
            api.getBlacklist().addWellOfSuffering(entityEntry.getRegistryName());
        }
    }
}

