/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.PacketListToClient;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.logic.ParameterTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVariablesReady
extends PacketListToClient<Parameter> {
    public PacketVariablesReady() {
    }

    public PacketVariablesReady(BlockPos pos, String command, List<Parameter> list) {
        super(pos, command, list);
    }

    protected Parameter createItem(ByteBuf buf) {
        return ParameterTools.readFromBuf(buf);
    }

    protected void writeItemToBuf(ByteBuf buf, Parameter item) {
        if (item == null) {
            buf.writeByte(-1);
        } else {
            ParameterTools.writeToBuf(buf, item);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketVariablesReady, IMessage> {
        public IMessage onMessage(PacketVariablesReady message, MessageContext ctx) {
            RFToolsControl.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketVariablesReady message, MessageContext ctx) {
            TileEntity te = RFToolsControl.proxy.getClientWorld().func_175625_s(message.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(message.command, message.list, Type.create(Parameter.class))) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
            }
        }
    }
}

