/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.net;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibCommon;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.SyncGamerulesEvent;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ISyncData;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftblib.lib.util.SidedUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.net.FTBLibNetHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSyncData
extends MessageToClient {
    private static final int LOGIN = 1;
    private int flags;
    private UUID universeId;
    private NBTTagCompound syncData;
    private Map<String, String> gamerules;

    public MessageSyncData() {
    }

    public MessageSyncData(boolean login, EntityPlayerMP player, ForgePlayer forgePlayer) {
        this.flags = Bits.setFlag(0, 1, login);
        this.universeId = forgePlayer.team.universe.getUUID();
        this.syncData = new NBTTagCompound();
        for (Map.Entry<String, ISyncData> entry : FTBLibCommon.SYNCED_DATA.entrySet()) {
            this.syncData.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().writeSyncData(player, forgePlayer));
        }
        this.gamerules = new HashMap<String, String>();
        new SyncGamerulesEvent(gamerule -> this.gamerules.put((String)gamerule, player.field_70170_p.func_82736_K().func_82767_a(gamerule))).post();
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeByte(this.flags);
        data.writeUUID(this.universeId);
        data.writeNBT(this.syncData);
        data.writeMap(this.gamerules, DataOut.STRING, DataOut.STRING);
    }

    @Override
    public void readData(DataIn data) {
        this.flags = data.readByte();
        this.universeId = data.readUUID();
        this.syncData = data.readNBT();
        this.gamerules = data.readMap(DataIn.STRING, DataIn.STRING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        SidedUtils.UNIVERSE_UUID_CLIENT = this.universeId;
        for (String string : this.syncData.func_150296_c()) {
            ISyncData nbt = FTBLibCommon.SYNCED_DATA.get(string);
            if (nbt == null) continue;
            nbt.readSyncData(this.syncData.func_74775_l(string));
        }
        for (Map.Entry entry : this.gamerules.entrySet()) {
            ClientUtils.MC.field_71441_e.func_82736_K().func_82764_b((String)entry.getKey(), (String)entry.getValue());
        }
        if (FTBLibConfig.debugging.print_more_info && Bits.getFlag(this.flags, 1)) {
            FTBLib.LOGGER.info("Synced data from universe " + StringUtils.fromUUID(SidedUtils.UNIVERSE_UUID_CLIENT));
        }
    }
}

