/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.item.matcher;

import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftblib.lib.item.matcher.IItemMatcher;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackMatcher
implements IItemMatcher {
    public static final ItemStackMatcher EMPTY = new ItemStackMatcher(){

        @Override
        public boolean test(ItemStack stack) {
            return stack.func_190926_b();
        }
    };
    private ItemStack stack = ItemStack.field_190927_a;
    private boolean ignoreMetadata = false;
    private boolean ignoreNBT = false;
    private Item item;
    private int meta;
    private NBTTagCompound nbt;

    public void setStack(ItemStack is) {
        this.stack = is;
        this.clearCache();
    }

    public void setIgnoreMetadata(boolean v) {
        this.ignoreMetadata = v;
        this.clearCache();
    }

    public void setIgnoreNBT(boolean v) {
        this.ignoreNBT = v;
        this.clearCache();
    }

    @Override
    public NBTBase toNBT(boolean forceTagCompound) {
        if (this.ignoreMetadata || this.ignoreNBT || forceTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)ItemStackSerializer.write(this.stack, true);
            if (this.ignoreMetadata) {
                nbt.func_74757_a("ignoreMeta", true);
            }
            if (this.ignoreNBT) {
                nbt.func_74757_a("ignoreNBT", true);
            }
            return nbt;
        }
        return null;
    }

    @Override
    public void fromNBT(NBTBase nbt) {
        this.stack = ItemStackSerializer.read(nbt);
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound n = (NBTTagCompound)nbt;
            this.ignoreMetadata = n.func_74767_n("ignoreMeta");
            this.ignoreNBT = n.func_74767_n("ignoreNBT");
        } else {
            this.ignoreMetadata = false;
            this.ignoreNBT = false;
        }
    }

    @Override
    public boolean test(ItemStack is) {
        if (is == this.stack) {
            return true;
        }
        if (this.item == null) {
            this.item = this.stack.func_77973_b();
            this.meta = this.ignoreMetadata ? 0 : this.stack.func_77960_j();
            this.nbt = this.ignoreNBT ? null : this.item.getNBTShareTag(this.stack);
        }
        return !(is.func_77973_b() != this.item || !this.ignoreMetadata && is.func_77960_j() != this.meta || !this.ignoreNBT && !Objects.equals(is.func_77973_b().getNBTShareTag(is), this.nbt));
    }

    @Override
    public boolean isValid() {
        return !this.stack.func_190926_b();
    }

    @Override
    public void clearCache() {
        this.item = null;
        this.meta = 0;
        this.nbt = null;
    }

    @Override
    public void getAllStacks(Collection<ItemStack> stacks) {
        stacks.add(this.stack);
    }
}

