/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IIteratingConfig;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigStringEnum
extends ConfigValue
implements IIteratingConfig {
    private final List<String> keys;
    private String value;
    private final Map<String, ITextComponent> customNames;
    private final Map<String, Color4I> customColors;

    public ConfigStringEnum(Collection<String> k, String v) {
        this.keys = new ArrayList<String>(k);
        this.value = v;
        this.customNames = new HashMap<String, ITextComponent>();
        this.customColors = new HashMap<String, Color4I>();
    }

    public String func_176610_l() {
        return "enum";
    }

    public void setString(String v) {
        this.value = v;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public ITextComponent getStringForGUI() {
        ITextComponent textComponent = this.customNames.get(this.getString());
        return textComponent == null ? new TextComponentString(this.getString()) : textComponent.func_150259_f();
    }

    public void setCustomName(String key, @Nullable ITextComponent component) {
        if (component == null) {
            this.customNames.remove(key);
        } else {
            this.customNames.put(key, component);
        }
    }

    public void setCustomColor(String key, Color4I col) {
        if (col.isEmpty()) {
            this.customColors.remove(key);
        } else {
            this.customColors.put(key, col);
        }
    }

    @Override
    public boolean getBoolean() {
        return !this.getString().equals("-");
    }

    @Override
    public int getInt() {
        return this.keys.indexOf(this.getString());
    }

    @Override
    public ConfigStringEnum copy() {
        ConfigStringEnum config = new ConfigStringEnum(this.keys, this.getString());
        for (Map.Entry<String, ITextComponent> entry : this.customNames.entrySet()) {
            config.customNames.put(entry.getKey(), entry.getValue().func_150259_f());
        }
        for (Map.Entry<String, Object> entry : this.customColors.entrySet()) {
            config.customColors.put(entry.getKey(), ((Color4I)entry.getValue()).copy());
        }
        return config;
    }

    @Override
    public Color4I getColor() {
        Color4I color4I = this.customColors.get(this.getString());
        return color4I == null || color4I.isEmpty() ? ConfigEnum.COLOR : color4I;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            ITextComponent component = this.customNames.get(inst.getDefaultValue().getString());
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + (component == null ? inst.getDefaultValue() : component.func_150254_d()));
        }
    }

    @Override
    public List<String> getVariants() {
        return Collections.unmodifiableList(this.keys);
    }

    @Override
    public void iterate(ConfigValueInstance inst, boolean next) {
        if (inst.getCanEdit()) {
            this.setString(this.keys.get(MathUtils.mod(this.getInt() + (next ? 1 : -1), this.keys.size())));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74778_a(key, this.getString());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setString(nbt.func_74779_i(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeShort(this.keys.size());
        for (String s : this.keys) {
            data.writeString(s);
            data.writeTextComponent(this.customNames.get(s));
            data.writeIcon(this.customColors.get(s));
        }
        data.writeShort(this.getInt());
    }

    @Override
    public void readData(DataIn data) {
        this.keys.clear();
        this.customNames.clear();
        this.customColors.clear();
        int s = data.readUnsignedShort();
        while (--s >= 0) {
            String key = data.readString();
            this.keys.add(key);
            this.setCustomName(key, data.readTextComponent());
            Icon i = data.readIcon();
            if (!(i instanceof Color4I)) continue;
            this.setCustomColor(key, (Color4I)i);
        }
        this.setString(this.keys.get(data.readUnsignedShort()));
    }
}

