/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.client;

import com.feed_the_beast.ftblib.lib.util.misc.TextureSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class SpriteSet {
    public static final SpriteSet EMPTY = new SpriteSet(){

        @Override
        @Nullable
        public TextureAtlasSprite get(EnumFacing f) {
            return null;
        }

        @Override
        public SpriteSet exclude(EnumFacing ... f) {
            return this;
        }
    };
    private final TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];

    public static SpriteSet of(TextureSet set, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        for (ResourceLocation id : set.textures) {
            if (id == null) continue;
            return new SpriteSet(set, bakedTextureGetter);
        }
        return EMPTY;
    }

    private SpriteSet() {
    }

    public SpriteSet(TextureSet set, Function<ResourceLocation, TextureAtlasSprite> function) {
        this();
        for (int i = 0; i < 6; ++i) {
            ResourceLocation tex = set.getTexture(EnumFacing.field_82609_l[i]);
            this.sprites[i] = tex == null ? null : function.apply(tex);
        }
    }

    @Nullable
    public TextureAtlasSprite get(EnumFacing f) {
        return this.sprites[f.ordinal()];
    }

    public SpriteSet exclude(EnumFacing ... f) {
        SpriteSet set = new SpriteSet();
        System.arraycopy(this.sprites, 0, set.sprites, 0, 6);
        for (EnumFacing facing : f) {
            set.sprites[facing.ordinal()] = null;
        }
        return set;
    }
}

