/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.client;

import com.feed_the_beast.ftblib.lib.client.SpriteSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import org.lwjgl.util.vector.Vector3f;

public class ModelBuilder {
    private static final FaceBakery BAKERY = new FaceBakery();
    public final VertexFormat format;
    private List<BakedQuad> quads;
    private ModelRotation rotation;
    private boolean uvLocked = true;
    private boolean shade = true;
    private int tintIndex = -1;

    public ModelBuilder(VertexFormat f, ModelRotation r) {
        this.format = f;
        this.quads = new ArrayList<BakedQuad>();
        this.rotation = r;
    }

    public void setRotation(ModelRotation r) {
        this.rotation = r;
    }

    public void setUVLocked(boolean b) {
        this.uvLocked = b;
    }

    public void setShade(boolean b) {
        this.shade = b;
    }

    public void setTintIndex(int i) {
        this.tintIndex = -i;
    }

    public List<BakedQuad> getQuads() {
        return this.quads;
    }

    public void addCube(Vector3f from, Vector3f to, SpriteSet sprites) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addQuad(from, to, facing, sprites.get(facing));
        }
    }

    public void addCube(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, SpriteSet sprites) {
        this.addCube(new Vector3f(fromX, fromY, fromZ), new Vector3f(toX, toY, toZ), sprites);
    }

    public void addInvertedCube(Vector3f from, Vector3f to, SpriteSet sprites) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addQuad(to, from, facing, sprites.get(facing));
        }
    }

    public void addInvertedCube(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, SpriteSet sprites) {
        this.addInvertedCube(new Vector3f(fromX, fromY, fromZ), new Vector3f(toX, toY, toZ), sprites);
    }

    private static float[] getUV(Vector3f from, Vector3f to, EnumFacing face) {
        switch (face) {
            case DOWN: {
                return new float[]{from.x, 16.0f - to.z, to.x, 16.0f - from.z};
            }
            case UP: {
                return new float[]{from.x, from.z, to.x, to.z};
            }
            default: {
                return new float[]{16.0f - to.x, 16.0f - to.y, 16.0f - from.x, 16.0f - from.y};
            }
            case SOUTH: {
                return new float[]{from.x, 16.0f - to.y, to.x, 16.0f - from.y};
            }
            case WEST: {
                return new float[]{from.z, 16.0f - to.y, to.z, 16.0f - from.y};
            }
            case EAST: 
        }
        return new float[]{16.0f - to.z, 16.0f - to.y, 16.0f - from.z, 16.0f - from.y};
    }

    public void addQuad(Vector3f from, Vector3f to, EnumFacing face, @Nullable TextureAtlasSprite sprite) {
        if (sprite != null) {
            float[] uv = ModelBuilder.getUV(from, to, face);
            this.quads.add(BAKERY.func_178414_a(from, to, new BlockPartFace(face, this.tintIndex, "", new BlockFaceUV(uv, 0)), sprite, face, this.rotation, null, this.uvLocked, this.shade));
        }
    }

    public void addQuad(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, EnumFacing face, @Nullable TextureAtlasSprite sprite) {
        this.addQuad(new Vector3f(fromX, fromY, fromZ), new Vector3f(toX, toY, toZ), face, sprite);
    }
}

