/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client.teamsgui;

import com.feed_the_beast.ftblib.client.teamsgui.GuiCreateTeam;
import com.feed_the_beast.ftblib.client.teamsgui.PublicTeamData;
import com.feed_the_beast.ftblib.lib.EnumTeamStatus;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiSelectTeam
extends GuiButtonListBase {
    private final boolean canCreate;
    private final List<PublicTeamData> teams;

    public GuiSelectTeam(Collection<PublicTeamData> teams0, boolean c) {
        this.setTitle(I18n.func_135052_a((String)"team_action.ftblib.select_team", (Object[])new Object[0]));
        this.setHasSearchBox(true);
        this.teams = new ArrayList<PublicTeamData>(teams0);
        this.teams.sort(null);
        this.canCreate = c;
    }

    @Override
    public void addButtons(Panel panel) {
        panel.add(new ButtonCreateTeam(panel, this.canCreate));
        for (PublicTeamData t : this.teams) {
            panel.add(new ButtonTeam(panel, t));
        }
    }

    private static class ButtonTeam
    extends SimpleTextButton {
        private final PublicTeamData team;

        private ButtonTeam(Panel panel, PublicTeamData t) {
            super(panel, t.displayName.func_150260_c(), t.icon.withOutline(t.color.getColor(), false));
            this.team = t;
            if (this.team.type == PublicTeamData.Type.REQUESTING_INVITE) {
                this.setTitle(TextFormatting.AQUA + this.getTitle());
            } else if (this.team.type == PublicTeamData.Type.ENEMY) {
                this.setTitle(TextFormatting.RED + this.getTitle());
            } else if (this.team.type == PublicTeamData.Type.CAN_JOIN) {
                this.setTitle(TextFormatting.GREEN + this.getTitle());
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (this.team.type == PublicTeamData.Type.CAN_JOIN) {
                ClientUtils.execClientCommand("/team join " + this.team.func_176610_l());
                this.getGui().closeGui();
            } else if (this.team.type != PublicTeamData.Type.ENEMY && this.team.type != PublicTeamData.Type.REQUESTING_INVITE) {
                ClientUtils.execClientCommand("/team request_invite " + this.team.func_176610_l());
                this.team.type = PublicTeamData.Type.REQUESTING_INVITE;
                this.setTitle(TextFormatting.AQUA + this.getTitle());
                this.parent.alignWidgets();
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (!this.team.description.isEmpty()) {
                list.add(TextFormatting.ITALIC + this.team.description);
            }
            if (this.team.type == PublicTeamData.Type.REQUESTING_INVITE) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftblib.lang.team_status.requesting_invite", (Object[])new Object[0]));
            } else if (this.team.type == PublicTeamData.Type.ENEMY) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)EnumTeamStatus.ENEMY.getLangKey(), (Object[])new Object[0]));
            } else {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)(this.team.type == PublicTeamData.Type.CAN_JOIN ? "ftblib.lang.team.gui.join_team" : "ftblib.lang.team.gui.request_invite"), (Object[])new Object[]{this.team.color.getTextFormatting() + this.team.func_176610_l() + TextFormatting.GRAY}));
            }
        }

        @Override
        public WidgetType getWidgetType() {
            return this.team.type == PublicTeamData.Type.ENEMY ? WidgetType.DISABLED : WidgetType.mouseOver(this.isMouseOver());
        }
    }

    private static class ButtonCreateTeam
    extends SimpleTextButton {
        private final boolean canCreate;

        private ButtonCreateTeam(Panel panel, boolean c) {
            super(panel, I18n.func_135052_a((String)"team_action.ftblib.create_team", (Object[])new Object[0]), GuiIcons.ADD);
            this.canCreate = c;
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiCreateTeam().openGui();
        }

        @Override
        public WidgetType getWidgetType() {
            return this.canCreate ? WidgetType.mouseOver(this.isMouseOver()) : WidgetType.DISABLED;
        }
    }
}

