/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import romelo333.notenoughwands.ModItems;
import romelo333.notenoughwands.varia.Tools;

public class ProtectedBlocks
extends AbstractWorldData<ProtectedBlocks> {
    private static final String NAME = "NEWProtectedBlocks";
    private Map<GlobalCoordinate, Integer> blocks = new HashMap<GlobalCoordinate, Integer>();
    private Map<Pair<Integer, ChunkPos>, Set<BlockPos>> perDimPerChunkCache = new HashMap<Pair<Integer, ChunkPos>, Set<BlockPos>>();
    private Map<Integer, Integer> counter = new HashMap<Integer, Integer>();
    private int lastId = 1;
    public static int clientSideWorld = Integer.MAX_VALUE;
    public static Map<ChunkPos, Set<BlockPos>> clientSideProtectedBlocks = new HashMap<ChunkPos, Set<BlockPos>>();

    public ProtectedBlocks(String name) {
        super(name);
    }

    public void clear() {
        this.blocks.clear();
        this.perDimPerChunkCache.clear();
        this.counter.clear();
        this.lastId = -1;
    }

    public static ProtectedBlocks getProtectedBlocks(World world) {
        return (ProtectedBlocks)ProtectedBlocks.getData((World)world, ProtectedBlocks.class, (String)NAME);
    }

    public static boolean isProtectedClientSide(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!clientSideProtectedBlocks.containsKey(chunkPos)) {
            return false;
        }
        Set<BlockPos> positions = clientSideProtectedBlocks.get(chunkPos);
        return positions.contains(pos);
    }

    public int getNewId() {
        ++this.lastId;
        this.save();
        return this.lastId - 1;
    }

    private void decrementProtection(Integer oldId) {
        int cnt = this.counter.containsKey(oldId) ? this.counter.get(oldId) : 0;
        this.counter.put(oldId, --cnt);
    }

    private void incrementProtection(Integer newId) {
        int cnt = this.counter.containsKey(newId) ? this.counter.get(newId) : 0;
        this.counter.put(newId, ++cnt);
    }

    public int getProtectedBlockCount(int id) {
        return this.counter.containsKey(id) ? this.counter.get(id) : 0;
    }

    private int getMaxProtectedBlocks(int id) {
        if (id == -1) {
            return ModItems.masterProtectionWand.maximumProtectedBlocks;
        }
        return ModItems.protectionWand.maximumProtectedBlocks;
    }

    public boolean protect(EntityPlayer player, World world, BlockPos pos, int id) {
        int max;
        GlobalCoordinate key = new GlobalCoordinate(pos, world.field_73011_w.getDimension());
        if (id != -1 && this.blocks.containsKey(key)) {
            Tools.error(player, "This block is already protected!");
            return false;
        }
        if (this.blocks.containsKey(key)) {
            this.decrementProtection(this.blocks.get(key));
        }
        if ((max = this.getMaxProtectedBlocks(id)) != 0 && this.getProtectedBlockCount(id) >= max) {
            Tools.error(player, "Maximum number of protected blocks reached!");
            return false;
        }
        this.blocks.put(key, id);
        this.clearCache(key);
        this.incrementProtection(id);
        this.save();
        return true;
    }

    public boolean unprotect(EntityPlayer player, World world, BlockPos pos, int id) {
        GlobalCoordinate key = new GlobalCoordinate(pos, world.field_73011_w.getDimension());
        if (!this.blocks.containsKey(key)) {
            Tools.error(player, "This block is not protected!");
            return false;
        }
        if (id != -1 && this.blocks.get(key) != id) {
            Tools.error(player, "You have no permission to unprotect this block!");
            return false;
        }
        this.decrementProtection(this.blocks.get(key));
        this.blocks.remove(key);
        this.clearCache(key);
        this.save();
        return true;
    }

    public int clearProtections(World world, int id) {
        HashSet<GlobalCoordinate> toRemove = new HashSet<GlobalCoordinate>();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            if (entry.getValue() != id) continue;
            toRemove.add(entry.getKey());
        }
        int cnt = 0;
        for (GlobalCoordinate coordinate : toRemove) {
            ++cnt;
            this.blocks.remove(coordinate);
            this.clearCache(coordinate);
        }
        this.counter.put(id, 0);
        this.save();
        return cnt;
    }

    public boolean isProtected(World world, BlockPos pos) {
        return this.blocks.containsKey(new GlobalCoordinate(pos, world.field_73011_w.getDimension()));
    }

    public boolean hasProtections() {
        return !this.blocks.isEmpty();
    }

    public void fetchProtectedBlocks(Set<BlockPos> coordinates, World world, int x, int y, int z, float radius, int id) {
        radius *= radius;
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            BlockPos c;
            float sqdist;
            GlobalCoordinate block;
            if (entry.getValue() != id && (id != -2 || entry.getValue() == -1) || (block = entry.getKey()).getDimension() != world.field_73011_w.getDimension() || !((sqdist = (float)((x - (c = block.getCoordinate()).func_177958_n()) * (x - c.func_177958_n()) + (y - c.func_177956_o()) * (y - c.func_177956_o()) + (z - c.func_177952_p()) * (z - c.func_177952_p()))) < radius)) continue;
            coordinates.add(c);
        }
    }

    private void clearCache(GlobalCoordinate pos) {
        ChunkPos chunkpos = new ChunkPos(pos.getCoordinate());
        this.perDimPerChunkCache.remove(Pair.of((Object)pos.getDimension(), (Object)chunkpos));
    }

    public Map<ChunkPos, Set<BlockPos>> fetchProtectedBlocks(World world, BlockPos pos) {
        HashMap<ChunkPos, Set<BlockPos>> result = new HashMap<ChunkPos, Set<BlockPos>>();
        ChunkPos chunkpos = new ChunkPos(pos);
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a - 1, chunkpos.field_77275_b - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a, chunkpos.field_77275_b - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a + 1, chunkpos.field_77275_b - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a - 1, chunkpos.field_77275_b));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a, chunkpos.field_77275_b));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a + 1, chunkpos.field_77275_b));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a - 1, chunkpos.field_77275_b + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a, chunkpos.field_77275_b + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.field_77276_a + 1, chunkpos.field_77275_b + 1));
        return result;
    }

    public void fetchProtectedBlocks(Map<ChunkPos, Set<BlockPos>> allresults, World world, ChunkPos chunkpos) {
        Pair key = Pair.of((Object)world.field_73011_w.getDimension(), (Object)chunkpos);
        if (this.perDimPerChunkCache.containsKey(key)) {
            allresults.put(chunkpos, this.perDimPerChunkCache.get(key));
            return;
        }
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            ChunkPos bc;
            GlobalCoordinate block = entry.getKey();
            if (block.getDimension() != world.field_73011_w.getDimension() || !(bc = new ChunkPos(block.getCoordinate())).equals((Object)chunkpos)) continue;
            result.add(block.getCoordinate());
        }
        allresults.put(chunkpos, result);
        this.perDimPerChunkCache.put((Pair<Integer, ChunkPos>)key, result);
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.lastId = tagCompound.func_74762_e("lastId");
        this.blocks.clear();
        this.perDimPerChunkCache.clear();
        this.counter.clear();
        NBTTagList list = tagCompound.func_150295_c("blocks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            GlobalCoordinate block = new GlobalCoordinate(new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z")), tc.func_74762_e("dim"));
            int id = tc.func_74762_e("id");
            this.blocks.put(block, id);
            this.incrementProtection(id);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("lastId", this.lastId);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            GlobalCoordinate block = entry.getKey();
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("x", block.getCoordinate().func_177958_n());
            tc.func_74768_a("y", block.getCoordinate().func_177956_o());
            tc.func_74768_a("z", block.getCoordinate().func_177952_p());
            tc.func_74768_a("dim", block.getDimension());
            tc.func_74768_a("id", entry.getValue().intValue());
            list.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("blocks", (NBTBase)list);
        return tagCompound;
    }
}

