/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wireless;

import com.enderio.core.client.render.BoundingBox;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.machines.config.config.ChargerConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.wireless.BlockNormalWirelessCharger;
import crazypants.enderio.machines.machine.wireless.TileWirelessCharger;
import crazypants.enderio.machines.machine.wireless.WirelessRenderMapper;
import crazypants.enderio.util.ClientUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWirelessCharger
extends BlockNormalWirelessCharger
implements ISmartRenderAwareBlock,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockWirelessCharger create(@Nonnull IModObject modObject) {
        BlockWirelessCharger res = new BlockWirelessCharger(modObject);
        res.init();
        return res;
    }

    private BlockWirelessCharger(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    protected void init() {
        SmartModelAttacher.register((Block)this);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public final IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
        TileWirelessCharger tileEntity = (TileWirelessCharger)this.getTileEntitySafe(world, pos);
        if (tileEntity != null) {
            this.setBlockStateWrapperCache(blockStateWrapper, world, pos, tileEntity);
        }
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileWirelessCharger tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.isActive());
    }

    @Nonnull
    private BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return WirelessRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return WirelessRenderMapper.instance;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    @Override
    public void registerRenderers(@Nonnull IModObject modObject) {
        ClientUtil.registerDefaultItemRenderer(MachineObject.block_wireless_charger);
    }

    @Override
    @Nonnull
    protected BoundingBox getChargingStrength(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
        return new BoundingBox(pos).expand((double)ChargerConfig.wirelessRange.get().intValue());
    }

    @Override
    protected boolean isAntenna() {
        return false;
    }
}

