/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.anchor;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.UserIdent;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityPoweredMachineEntity;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.machines.integration.ftblib.FtblIntegration;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileTravelAnchor
extends AbstractCapabilityPoweredMachineEntity
implements ITravelAccessable,
IPaintable.IPaintableTileEntity {
    @Store
    protected IBlockState sourceBlock;
    @Store
    @Nonnull
    private ITravelAccessable.AccessMode accessMode = ITravelAccessable.AccessMode.PUBLIC;
    @Store
    @Nonnull
    private NNList<ItemStack> password = new NNList(5, (Object)ItemStack.field_190927_a);
    @Store
    @Nonnull
    private ItemStack itemLabel = ItemStack.field_190927_a;
    @Store
    private String label;
    @Store
    private List<UserIdent> authorisedUsers = new ArrayList<UserIdent>();
    @Store
    private boolean visible = true;
    @Store(value={NBTAction.SAVE, NBTAction.CLIENT})
    @Nullable
    private UserIdent travelOwner;

    protected TileTravelAnchor(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(null, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    public TileTravelAnchor() {
        this(CapacitorKey.NO_POWER, CapacitorKey.NO_POWER, CapacitorKey.NO_POWER);
    }

    @Override
    public void setOwner(@Nonnull EntityPlayer player) {
        super.setOwner(player);
        this.travelOwner = UserIdent.create((GameProfile)player.func_146103_bH());
    }

    @Override
    @Nonnull
    public UserIdent getOwner() {
        return this.travelOwner != null ? this.travelOwner : super.getOwner();
    }

    private boolean isAuthorisedUser(UserIdent ident) {
        return this.authorisedUsers.contains(ident);
    }

    private boolean isOwnerUser(UserIdent ident) {
        return this.getOwner().equals(ident);
    }

    @Override
    public boolean canBlockBeAccessed(@Nonnull EntityPlayer playerName) {
        if (this.accessMode == ITravelAccessable.AccessMode.PUBLIC) {
            return true;
        }
        return this.isOwnerUser(UserIdent.create((GameProfile)playerName.func_146103_bH())) || this.isAuthorisedUser(UserIdent.create((GameProfile)playerName.func_146103_bH())) || FtblIntegration.isInSameTeam(UserIdent.create((GameProfile)playerName.func_146103_bH()), this.getOwner());
    }

    @Override
    public void clearAuthorisedUsers() {
        this.authorisedUsers.clear();
    }

    private boolean checkPassword(ItemStack[] pwd) {
        if (pwd == null || pwd.length != this.password.size()) {
            return false;
        }
        for (int i = 0; i < pwd.length; ++i) {
            ItemStack pw = (ItemStack)this.password.get(i);
            ItemStack tst = pwd[i];
            if (pw.func_190926_b() && !tst.func_190926_b()) {
                return false;
            }
            if (pw.func_190926_b() || !tst.func_190926_b() && ItemStack.func_77989_b((ItemStack)pw, (ItemStack)tst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getRequiresPassword(@Nonnull EntityPlayer playerName) {
        return this.getAccessMode() == ITravelAccessable.AccessMode.PROTECTED && !this.canUiBeAccessed(playerName) && !this.isAuthorisedUser(UserIdent.create((GameProfile)playerName.func_146103_bH()));
    }

    @Override
    public boolean authoriseUser(@Nonnull EntityPlayer username, @Nonnull ItemStack[] passwordIn) {
        if (this.checkPassword(passwordIn)) {
            this.authorisedUsers.add(UserIdent.create((GameProfile)username.func_146103_bH()));
            return true;
        }
        return false;
    }

    @Override
    public boolean canUiBeAccessed(@Nonnull EntityPlayer playerName) {
        return this.isOwnerUser(UserIdent.create((GameProfile)playerName.func_146103_bH()));
    }

    @Override
    public boolean canSeeBlock(@Nonnull EntityPlayer playerName) {
        if (this.accessMode != ITravelAccessable.AccessMode.PRIVATE) {
            return true;
        }
        UserIdent ident = UserIdent.create((GameProfile)playerName.func_146103_bH());
        return this.isOwnerUser(ident) || FtblIntegration.isInSameTeam(ident, this.getOwner());
    }

    @Override
    @Nonnull
    public ITravelAccessable.AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void setAccessMode(@Nonnull ITravelAccessable.AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(@Nonnull NNList<ItemStack> password) {
        this.password = password;
    }

    @Override
    @Nonnull
    public ItemStack getItemLabel() {
        return this.itemLabel;
    }

    @Override
    public void setItemLabel(@Nonnull ItemStack lableIcon) {
        this.itemLabel = lableIcon;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(@Nullable String label) {
        this.label = label;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public IBlockState getPaintSource() {
        return this.sourceBlock;
    }

    @Override
    public void setPaintSource(@Nullable IBlockState sourceBlock) {
        this.sourceBlock = sourceBlock;
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        return false;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode == IoMode.NONE;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

