/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.solar.SolarType;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SolarPanelRecipeCategory
extends BlankRecipeCategory<SolarPanelRecipeWrapper> {
    @Nonnull
    public static final String UID = "SolarPanel";
    @Nonnull
    private final IDrawable background;

    public static void register(@Nonnull IModRegistry registry, @Nonnull IGuiHelper guiHelper) {
        if (!PersonalConfig.enableSolarJEIRecipes.get().booleanValue()) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new SolarPanelRecipeCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 3), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 2), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 1), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 0), new String[]{UID});
        registry.addRecipes(Collections.singletonList(new SolarPanelRecipeWrapper(guiHelper)), UID);
    }

    public SolarPanelRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 95);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_solar_panel.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SolarPanelRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        int offset = 12;
        guiItemStacks.init(0, true, 0 + offset, 45);
        guiItemStacks.init(1, true, 40 + offset, 45);
        guiItemStacks.init(2, true, 80 + offset, 45);
        guiItemStacks.init(3, true, 120 + offset, 45);
        group.init(4, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 0, 80, 40, 10, 0, 0);
        group.init(5, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 40, 80, 40, 10, 0, 0);
        group.init(6, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 80, 80, 40, 10, 0, 0);
        group.init(7, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 120, 80, 40, 10, 0, 0);
        guiItemStacks.set(ingredients);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class SolarPanelRecipeWrapper
    extends BlankRecipeWrapper {
        @Nonnull
        private final IDrawable sun;

        public SolarPanelRecipeWrapper(@Nonnull IGuiHelper guiHelper) {
            ResourceLocation sunLocation = new ResourceLocation("enderio", "textures/gui/weather_sun.png");
            this.sun = guiHelper.createDrawable(sunLocation, 0, 0, 32, 32, 32, 32);
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputs(ItemStack.class, (List)new NNList((Object[])new ItemStack[]{new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 0), new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 1), new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 2), new ItemStack(MachineObject.block_solar_panel.getBlockNN(), 1, 3)}));
            ingredients.setOutputs(EnergyIngredient.class, (List)new NNList((Object[])new EnergyIngredient[]{new EnergyIngredient(Math.round(SolarType.SIMPLE.getRfperTick()), true), new EnergyIngredient(Math.round(SolarType.NORMAL.getRfperTick()), true), new EnergyIngredient(Math.round(SolarType.ADVANCED.getRfperTick()), true), new EnergyIngredient(Math.round(SolarType.VIBRANT.getRfperTick()), true)}));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            GlStateManager.func_179147_l();
            this.sun.draw(minecraft, 61, 0);
            FontRenderer fr = minecraft.field_71466_p;
            String txt = Lang.JEI_SOLAR_OUTPUT.get();
            int sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(recipeWidth / 2 - sw / 2), 68.0f, ColorUtil.getRGB((Color)Color.WHITE));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (mouseY >= 65) {
                return Lang.JEI_SOLAR_RANGE.getLines(new Object[0]);
            }
            return super.getTooltipStrings(mouseX, mouseY);
        }
    }
}

