/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.upgrades;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.integration.forestry.ForestryItemStacks;
import crazypants.enderio.integration.forestry.config.ForestryConfig;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class ApiaristArmorUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "apiarist_armor_";
    @Nonnull
    public static final ApiaristArmorUpgrade HELMET = new ApiaristArmorUpgrade(EntityEquipmentSlot.HEAD);
    @Nonnull
    public static final ApiaristArmorUpgrade CHEST = new ApiaristArmorUpgrade(EntityEquipmentSlot.CHEST);
    @Nonnull
    public static final ApiaristArmorUpgrade LEGS = new ApiaristArmorUpgrade(EntityEquipmentSlot.LEGS);
    @Nonnull
    public static final ApiaristArmorUpgrade BOOTS = new ApiaristArmorUpgrade(EntityEquipmentSlot.FEET);
    @Nonnull
    private final EntityEquipmentSlot slot;

    @Nonnull
    public static ItemStack getApiaristArmor(EntityEquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                return (ItemStack)NullHelper.first((Object[])new ItemStack[]{ForestryItemStacks.FORESTRY_FEET, Prep.getEmpty()});
            }
            case LEGS: {
                return (ItemStack)NullHelper.first((Object[])new ItemStack[]{ForestryItemStacks.FORESTRY_LEGS, Prep.getEmpty()});
            }
            case CHEST: {
                return (ItemStack)NullHelper.first((Object[])new ItemStack[]{ForestryItemStacks.FORESTRY_CHEST, Prep.getEmpty()});
            }
            case HEAD: {
                return (ItemStack)NullHelper.first((Object[])new ItemStack[]{ForestryItemStacks.FORESTRY_HEAD, Prep.getEmpty()});
            }
        }
        return Prep.getEmpty();
    }

    public ApiaristArmorUpgrade(@Nonnull EntityEquipmentSlot slot) {
        super("enderiointegrationforestry", UPGRADE_NAME + slot.func_188450_d(), "enderio.darksteel.upgrade.apiarist_armor." + slot.func_188450_d(), ApiaristArmorUpgrade.getApiaristArmor(slot), ForestryConfig.apiaristArmorCost);
        this.slot = slot;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(this.slot) && item.hasUpgradeCallbacks(this) && Prep.isValid(this.getUpgradeItem()) && !this.hasUpgrade(stack, item);
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeItem() {
        this.upgradeItem = ApiaristArmorUpgrade.getApiaristArmor(this.slot);
        return this.upgradeItem;
    }

    @Override
    @Nonnull
    public String getUpgradeItemName() {
        if (Prep.isInvalid(this.getUpgradeItem())) {
            return "(???)";
        }
        return super.getUpgradeItemName();
    }
}

