/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import com.enderio.core.client.render.IconUtil;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.conduits.conduit.power.IPowerConduitData;
import crazypants.enderio.conduits.conduit.power.PowerConduit;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.init.ConduitObject;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BasePowerConduitData
implements IPowerConduitData {
    private final int id;

    public BasePowerConduitData(int id) {
        this.id = id;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    @Nonnull
    public ItemStack createItemStackForSubtype() {
        return new ItemStack(ConduitObject.item_power_conduit.getItemNN(), 1, this.getID());
    }

    @Override
    public int getMaxEnergyIO() {
        switch (this.getID()) {
            case 1: {
                return ConduitConfig.tier2_maxIO.get();
            }
            case 2: {
                return ConduitConfig.tier3_maxIO.get();
            }
        }
        return ConduitConfig.tier1_maxIO.get();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return PowerConduit.ICONS.get("blocks/power_conduit_core" + PowerConduit.POSTFIX[this.getID()]).get(TextureAtlasSprite.class);
        }
        if ("ColorController".equals(component.data)) {
            return IconUtil.instance.whiteTexture;
        }
        return PowerConduit.ICONS.get("blocks/power_conduit" + PowerConduit.POSTFIX[this.getID()]).get(TextureAtlasSprite.class);
    }
}

