/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractClientConduit
implements IClientConduit.WithDefaultRendering {
    public static final float TRANSMISSION_SCALE = 0.3f;
    @Nonnull
    protected final Set<EnumFacing> conduitConnections = EnumSet.noneOf(EnumFacing.class);
    @Nonnull
    protected final Set<EnumFacing> externalConnections = EnumSet.noneOf(EnumFacing.class);
    @Nonnull
    protected final List<CollidableComponent> collidables = new ArrayList<CollidableComponent>();
    @Nonnull
    protected final EnumMap<EnumFacing, ConnectionMode> conectionModes = new EnumMap(EnumFacing.class);
    @Nullable
    protected IConduitBundle bundle;

    protected AbstractClientConduit() {
    }

    @Override
    @Nonnull
    public ConnectionMode getConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode res = this.conectionModes.get(dir);
        if (res == null) {
            return this.getDefaultConnectionMode();
        }
        return res;
    }

    @Nonnull
    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.IN_OUT;
    }

    @Override
    public boolean haveCollidablesChangedSinceLastCall() {
        return false;
    }

    @Override
    public void setBundle(@Nullable IConduitBundle tileConduitBundle) {
        this.bundle = tileConduitBundle;
    }

    @Override
    @Nonnull
    public IConduitBundle getBundle() {
        return (IConduitBundle)NullHelper.notnull((Object)this.bundle, (String)"Logic error in conduit---no bundle set");
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getConduitConnections() {
        return this.conduitConnections;
    }

    @Override
    public boolean containsConduitConnection(@Nonnull EnumFacing dir) {
        return this.conduitConnections.contains(dir);
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionMode) {
        return false;
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getExternalConnections() {
        return this.externalConnections;
    }

    @Override
    public boolean hasExternalConnections() {
        return !this.externalConnections.isEmpty();
    }

    @Override
    public boolean hasConduitConnections() {
        return !this.conduitConnections.isEmpty();
    }

    @Override
    public boolean containsExternalConnection(@Nonnull EnumFacing dir) {
        return this.externalConnections.contains(dir);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound conduitBody) {
        int i;
        this.conduitConnections.clear();
        int[] dirs = conduitBody.func_74759_k("connections");
        for (i = 0; i < dirs.length; ++i) {
            this.conduitConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.externalConnections.clear();
        dirs = conduitBody.func_74759_k("externalConnections");
        for (i = 0; i < dirs.length; ++i) {
            this.externalConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.conectionModes.clear();
        byte[] modes = conduitBody.func_74770_j("conModes");
        if (modes.length == 6) {
            int i2 = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.conectionModes.put(dir, ConnectionMode.values()[modes[i2]]);
                ++i2;
            }
        }
        CollidableCache cc = CollidableCache.instance;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir == null || !this.isConnectedTo(dir) || this.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
            this.collidables.addAll(cc.getCollidables(cc.createKey(this.getCollidableType(), this.getBundle().getOffset(this.getBaseConduitType(), dir), dir), this));
        }
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        return false;
    }

    @Override
    public float getSelfIlluminationForState(@Nonnull CollidableComponent component) {
        return this.isActive() ? 1.0f : 0.0f;
    }

    @Override
    public float getTransmitionGeometryScale() {
        return 0.3f;
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        return (Collection)NullHelper.notnullJ(Collections.singletonList(new CollidableComponent(this.getCollidableType(), ConduitGeometryUtil.instance.getBoundingBox(this.getBaseConduitType(), key.dir, key.offset), key.dir, null)), (String)"Collections#singletonList");
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getCollidableType() {
        return this.getBaseConduitType();
    }

    @Nonnull
    public List<CollidableComponent> getCollidableComponents() {
        return this.collidables;
    }

    @Override
    public boolean shouldMirrorTexture() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        hashCodes.add(this.getClass());
        hashCodes.add(this.conduitConnections, this.externalConnections, this.conectionModes);
    }
}

